/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.ViewIndexingTrigger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CodelessManager {
    private static final ViewIndexingTrigger viewIndexingTrigger = new ViewIndexingTrigger();
    @Nullable
    private static SensorManager sensorManager;
    @Nullable
    private static ViewIndexer viewIndexer;
    @Nullable
    private static String deviceSessionID;
    private static final AtomicBoolean isCodelessEnabled;
    private static Boolean isAppIndexingEnabled;
    private static volatile Boolean isCheckingSession;

    public static void onActivityResumed(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Activity activity2;
            if (!isCodelessEnabled.get()) {
                return;
            }
            CodelessMatcher.getInstance().add(activity2);
            Context applicationContext = activity2.getApplicationContext();
            final String appId = FacebookSdk.getApplicationId();
            final FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
            if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
                if (sensorManager == null) {
                    return;
                }
                Sensor accelerometer = sensorManager.getDefaultSensor(1);
                viewIndexer = new ViewIndexer(activity2);
                viewIndexingTrigger.setOnShakeListener(new ViewIndexingTrigger.OnShakeListener(){

                    @Override
                    public void onShake() {
                        boolean codelessSetupEnabled;
                        boolean codelessEventsEnabled;
                        boolean bl = codelessEventsEnabled = appSettings != null && appSettings.getCodelessEventsEnabled();
                        boolean bl2 = FacebookSdk.getCodelessSetupEnabled() ? true : (codelessSetupEnabled = false);
                        if (codelessEventsEnabled && codelessSetupEnabled) {
                            CodelessManager.access$000(appId);
                        }
                    }
                });
                sensorManager.registerListener((SensorEventListener)viewIndexingTrigger, accelerometer, 2);
                if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                    viewIndexer.schedule();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    public static void onActivityPaused(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Activity activity2;
            if (!isCodelessEnabled.get()) {
                return;
            }
            CodelessMatcher.getInstance().remove(activity2);
            if (null != viewIndexer) {
                viewIndexer.unschedule();
            }
            if (null != sensorManager) {
                sensorManager.unregisterListener((SensorEventListener)viewIndexingTrigger);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    public static void onActivityDestroyed(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Activity activity2;
            CodelessMatcher.getInstance().destroy(activity2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    public static void enable() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            isCodelessEnabled.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    public static void disable() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            isCodelessEnabled.set(false);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    private static void checkCodelessSession(String string) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            String applicationId;
            if (isCheckingSession.booleanValue()) {
                return;
            }
            isCheckingSession = true;
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        GraphRequest request = GraphRequest.newPostRequest(null, String.format(Locale.US, "%s/app_indexing_session", applicationId), null, null);
                        Bundle requestParameters = request.getParameters();
                        if (requestParameters == null) {
                            requestParameters = new Bundle();
                        }
                        Context context = FacebookSdk.getApplicationContext();
                        AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                        JSONArray extInfoArray = new JSONArray();
                        extInfoArray.put((Object)(Build.MODEL != null ? Build.MODEL : ""));
                        if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                            extInfoArray.put((Object)identifiers.getAndroidAdvertiserId());
                        } else {
                            extInfoArray.put((Object)"");
                        }
                        extInfoArray.put((Object)"0");
                        extInfoArray.put((Object)(AppEventUtility.isEmulator() ? "1" : "0"));
                        Locale locale = Utility.getCurrentLocale();
                        extInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
                        String extInfo = extInfoArray.toString();
                        requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID());
                        requestParameters.putString("extinfo", extInfo);
                        request.setParameters(requestParameters);
                        GraphResponse res = request.executeAndWait();
                        JSONObject jsonRes = res.getJSONObject();
                        CodelessManager.access$102(jsonRes != null && jsonRes.optBoolean("is_app_indexing_enabled", false));
                        if (!CodelessManager.access$100().booleanValue()) {
                            CodelessManager.access$202(null);
                        } else if (null != CodelessManager.access$300()) {
                            CodelessManager.access$300().schedule();
                        }
                        CodelessManager.access$402(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    static String getCurrentDeviceSessionID() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            if (null == deviceSessionID) {
                deviceSessionID = UUID.randomUUID().toString();
            }
            return deviceSessionID;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static boolean getIsAppIndexingEnabled() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return false;
        }
        try {
            return isAppIndexingEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return false;
        }
    }

    static void updateAppIndexing(Boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            Boolean appIndexingEnalbed;
            isAppIndexingEnabled = appIndexingEnalbed;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    static /* synthetic */ void access$000(String string) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return;
        }
        try {
            String x0;
            CodelessManager.checkCodelessSession(x0);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return;
        }
    }

    static /* synthetic */ Boolean access$102(Boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            Boolean x0;
            isAppIndexingEnabled = x0;
            return isAppIndexingEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static /* synthetic */ Boolean access$100() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            return isAppIndexingEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static /* synthetic */ String access$202(String string) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            String x0;
            deviceSessionID = x0;
            return deviceSessionID;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static /* synthetic */ ViewIndexer access$300() {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            return viewIndexer;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static /* synthetic */ Boolean access$402(Boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(CodelessManager.class)) {
            return null;
        }
        try {
            Boolean x0;
            isCheckingSession = x0;
            return isCheckingSession;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessManager.class);
            return null;
        }
    }

    static {
        isCodelessEnabled = new AtomicBoolean(true);
        isAppIndexingEnabled = false;
        isCheckingSession = false;
    }
}

