/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import androidx.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

final class HashUtils {
    private static final String MD5 = "MD5";

    HashUtils() {
    }

    @Nullable
    public static final String computeChecksum(String path) throws Exception {
        return HashUtils.computeFileMd5(new File(path));
    }

    @Nullable
    private static String computeFileMd5(File file) throws Exception {
        int BUFFER_SIZE = 1024;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file), 1024);){
            int numRead;
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] buffer = new byte[1024];
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
            } while (numRead != -1);
            String string = new BigInteger(1, md.digest()).toString(16);
            return string;
        }
    }
}

