/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads_identifier.zze;
import com.google.android.gms.internal.ads_identifier.zzf;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@KeepForSdk
public class AdvertisingIdClient {
    @GuardedBy(value="this")
    @Nullable
    private BlockingServiceConnection zze;
    @GuardedBy(value="this")
    @Nullable
    private zze zzf;
    @GuardedBy(value="this")
    private boolean zzg;
    private final Object zzh = new Object();
    @GuardedBy(value="mAutoDisconnectTaskLock")
    @Nullable
    private zza zzi;
    @GuardedBy(value="this")
    private final Context mContext;
    private final boolean zzj;
    private final long zzk;

    @KeepForSdk
    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false, false);
    }

    @VisibleForTesting
    private AdvertisingIdClient(Context context, long l, boolean bl, boolean bl2) {
        Context context2;
        Preconditions.checkNotNull((Object)context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzg = false;
        this.zzk = l;
        this.zzj = bl2;
    }

    @KeepForSdk
    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zza(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void zza(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzg) {
                this.finish();
            }
            this.zze = AdvertisingIdClient.zza(this.mContext, this.zzj);
            this.zzf = AdvertisingIdClient.zza(this.mContext, this.zze);
            this.zzg = true;
            if (bl) {
                this.zza();
            }
            return;
        }
    }

    @KeepForSdk
    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza() {
        Object object = this.zzh;
        synchronized (object) {
            if (this.zzi != null) {
                this.zzi.zzo.countDown();
                try {
                    this.zzi.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzk > 0L) {
                this.zzi = new zza(this, this.zzk);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public Info getInfo() throws IOException {
        Info info;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzg) {
                Object object = this.zzh;
                synchronized (object) {
                    if (this.zzi == null || !this.zzi.zzp) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zza(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzg) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            Preconditions.checkNotNull((Object)this.zze);
            Preconditions.checkNotNull((Object)this.zzf);
            try {
                info = new Info(this.zzf.getId(), this.zzf.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zza();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzb() throws IOException {
        boolean bl;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzg) {
                Object object = this.zzh;
                synchronized (object) {
                    if (this.zzi == null || !this.zzi.zzp) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zza(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzg) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            Preconditions.checkNotNull((Object)this.zze);
            Preconditions.checkNotNull((Object)this.zzf);
            try {
                bl = this.zzf.zzc();
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zza();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish() {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zze == null) {
                return;
            }
            try {
                if (this.zzg) {
                    ConnectionTracker.getInstance().unbindService(this.mContext, (ServiceConnection)this.zze);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzg = false;
            this.zzf = null;
            this.zze = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static BlockingServiceConnection zza(Context context, boolean bl) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        String string = bl ? "com.google.android.gms.ads.identifier.service.PERSISTENT_START" : "com.google.android.gms.ads.identifier.service.START";
        BlockingServiceConnection blockingServiceConnection = new BlockingServiceConnection();
        Intent intent = new Intent(string);
        intent.setPackage("com.google.android.gms");
        try {
            if (ConnectionTracker.getInstance().bindService(context, intent, (ServiceConnection)blockingServiceConnection, 1)) {
                return blockingServiceConnection;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    @KeepForSdk
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        float f = zzb2.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
        String string = zzb2.getString("gads:ad_id_use_shared_preference:experiment_id", "");
        boolean bl2 = zzb2.getBoolean("gads:ad_id_use_persistent_service:enabled", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            long l = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(false);
            Info info = advertisingIdClient.getInfo();
            long l2 = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(info, bl, f, l2 - l, string, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            advertisingIdClient.zza(null, bl, f, -1L, string, throwable);
            throw throwable;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    @KeepForSdk
    public static boolean getIsAdIdFakeForDebugLogging(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.getBoolean("gads:ad_id_app_context:enabled", false);
        boolean bl2 = zzb2.getBoolean("com.google.android.gms.ads.identifier.service.PERSISTENT_START", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            advertisingIdClient.zza(false);
            boolean bl3 = advertisingIdClient.zzb();
            return bl3;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    @VisibleForTesting
    private final boolean zza(Info info, boolean bl, float f, long l, String string, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string2 = string;
        long l2 = l;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string2 != null && !string2.isEmpty()) {
            hashMap.put("experiment_id", string2);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l2));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    @VisibleForTesting
    private static zze zza(Context context, BlockingServiceConnection blockingServiceConnection) throws IOException {
        try {
            return com.google.android.gms.internal.ads_identifier.zzf.zza(blockingServiceConnection.getServiceWithTimeout(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    @KeepForSdkWithMembers
    public static final class Info {
        private final String zzq;
        private final boolean zzr;

        public Info(String string, boolean bl) {
            this.zzq = string;
            this.zzr = bl;
        }

        public final String getId() {
            return this.zzq;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzr;
        }

        public final String toString() {
            String string = this.zzq;
            boolean bl = this.zzr;
            return new StringBuilder(7 + String.valueOf(string).length()).append("{").append(string).append("}").append(bl).toString();
        }
    }

    @VisibleForTesting
    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzm;
        private long zzn;
        CountDownLatch zzo;
        boolean zzp;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzm = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzn = l;
            this.zzo = new CountDownLatch(1);
            this.zzp = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzm.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzp = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzo.await(this.zzn, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

