/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zaaf;
import com.google.android.gms.common.api.internal.zabi;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zabw;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zach;
import com.google.android.gms.common.api.internal.zae;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GoogleApiAvailabilityCache;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SimpleClientAdapter;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.base.zal;
import com.google.android.gms.signin.zad;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class GoogleApiManager
implements Handler.Callback {
    public static final Status zahw = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zahx = new Status(4, "The user must be signed in to make this API call.");
    private long zahy = 5000L;
    private long zahz = 120000L;
    private long zaia = 10000L;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static GoogleApiManager zaib;
    private final Context zaic;
    private final GoogleApiAvailability zaid;
    private final GoogleApiAvailabilityCache zaie;
    private final AtomicInteger zaif = new AtomicInteger(1);
    private final AtomicInteger zaig = new AtomicInteger(0);
    private final Map<zai<?>, zaa<?>> zaih = new ConcurrentHashMap(5, 0.75f, 1);
    @GuardedBy(value="lock")
    private zaae zaii = null;
    @GuardedBy(value="lock")
    private final Set<zai<?>> zaij = new ArraySet();
    private final Set<zai<?>> zaik = new ArraySet();
    private final Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zab(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zaib == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zaib = new GoogleApiManager(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zaib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleApiManager zabc() {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)zaib, (Object)"Must guarantee manager is non-null before using getInstance");
            return zaib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reportSignOut() {
        Object object = lock;
        synchronized (object) {
            if (zaib != null) {
                GoogleApiManager googleApiManager = zaib;
                googleApiManager.zaig.incrementAndGet();
                googleApiManager.handler.sendMessageAtFrontOfQueue(googleApiManager.handler.obtainMessage(10));
            }
            return;
        }
    }

    @KeepForSdk
    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zaic = context;
        this.handler = new zal(looper, this);
        this.zaid = googleApiAvailability;
        this.zaie = new GoogleApiAvailabilityCache(googleApiAvailability);
        this.handler.sendMessage(this.handler.obtainMessage(6));
    }

    public final int zabd() {
        return this.zaif.getAndIncrement();
    }

    public final void zaa(GoogleApi<?> googleApi) {
        this.handler.sendMessage(this.handler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zab(GoogleApi<?> googleApi) {
        zai<?> zai2 = googleApi.zak();
        zaa<?> zaa2 = this.zaih.get(zai2);
        if (zaa2 == null) {
            zaa2 = new zaa(googleApi);
            this.zaih.put(zai2, zaa2);
        }
        if (zaa2.requiresSignIn()) {
            this.zaik.add(zai2);
        }
        zaa2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(@NonNull zaae zaae2) {
        Object object = lock;
        synchronized (object) {
            if (this.zaii != zaae2) {
                this.zaii = zaae2;
                this.zaij.clear();
            }
            this.zaij.addAll((Collection<zai<?>>)zaae2.zaaj());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zab(@NonNull zaae zaae2) {
        Object object = lock;
        synchronized (object) {
            if (this.zaii == zaae2) {
                this.zaii = null;
                this.zaij.clear();
            }
            return;
        }
    }

    public final Task<Map<zai<?>, String>> zaa(Iterable<? extends GoogleApi<?>> iterable) {
        zak zak2 = new zak(iterable);
        this.handler.sendMessage(this.handler.obtainMessage(2, (Object)zak2));
        return zak2.getTask();
    }

    public final void zao() {
        this.handler.sendMessage(this.handler.obtainMessage(3));
    }

    final void maybeSignOut() {
        this.zaig.incrementAndGet();
        this.handler.sendMessage(this.handler.obtainMessage(10));
    }

    public final Task<Boolean> zac(GoogleApi<?> googleApi) {
        zaaf zaaf2 = new zaaf(googleApi.zak());
        this.handler.sendMessage(this.handler.obtainMessage(14, (Object)zaaf2));
        return zaaf2.zaal().getTask();
    }

    public final <O extends Api.ApiOptions> void zaa(GoogleApi<O> googleApi, int n, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> apiMethodImpl) {
        zae<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>> zae2 = new zae<BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient>>(n, apiMethodImpl);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabv(zae2, this.zaig.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(GoogleApi<O> googleApi, int n, TaskApiCall<Api.AnyClient, ResultT> taskApiCall, TaskCompletionSource<ResultT> taskCompletionSource, StatusExceptionMapper statusExceptionMapper) {
        zag<ResultT> zag2 = new zag<ResultT>(n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        this.handler.sendMessage(this.handler.obtainMessage(4, (Object)new zabv(zag2, this.zaig.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zaa(@NonNull GoogleApi<O> googleApi, @NonNull RegisterListenerMethod<Api.AnyClient, ?> registerListenerMethod, @NonNull UnregisterListenerMethod<Api.AnyClient, ?> unregisterListenerMethod) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zaf zaf2 = new zaf(new zabw(registerListenerMethod, unregisterListenerMethod), (TaskCompletionSource<Void>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(8, (Object)new zabv(zaf2, this.zaig.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zaa(@NonNull GoogleApi<O> googleApi, @NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zah zah2 = new zah(listenerKey, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.handler.sendMessage(this.handler.obtainMessage(13, (Object)new zabv(zah2, this.zaig.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                GoogleApiManager googleApiManager = this;
                this.zaia = bl ? 10000L : 300000L;
                googleApiManager.handler.removeMessages(12);
                for (zai<?> zai2 : googleApiManager.zaih.keySet()) {
                    googleApiManager.handler.sendMessageDelayed(googleApiManager.handler.obtainMessage(12, zai2), googleApiManager.zaia);
                }
                break;
            }
            case 2: {
                zak zak2 = (zak)message.obj;
                GoogleApiManager googleApiManager = this;
                for (zai<?> zai3 : zak2.zap()) {
                    zaa<?> zaa2 = googleApiManager.zaih.get(zai3);
                    if (zaa2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zak2.zaa(zai3, connectionResult, null);
                        break block0;
                    }
                    if (zaa2.isConnected()) {
                        zak2.zaa(zai3, ConnectionResult.RESULT_SUCCESS, zaa2.zaab().getEndpointPackageName());
                        continue;
                    }
                    if (zaa2.zabm() != null) {
                        zak2.zaa(zai3, zaa2.zabm(), null);
                        continue;
                    }
                    zaa2.zaa(zak2);
                    zaa2.connect();
                }
                break;
            }
            case 3: {
                for (zaa<?> zaa3 : this.zaih.values()) {
                    zaa3.zabl();
                    zaa3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zabv zabv2 = (zabv)message.obj;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa4 = googleApiManager.zaih.get(zabv2.zajs.zak());
                if (zaa4 == null) {
                    googleApiManager.zab(zabv2.zajs);
                    zaa4 = googleApiManager.zaih.get(zabv2.zajs.zak());
                }
                if (zaa4.requiresSignIn() && googleApiManager.zaig.get() != zabv2.zajr) {
                    zabv2.zajq.zaa(zahw);
                    zaa4.zabj();
                    break;
                }
                zaa4.zaa(zabv2.zajq);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                GoogleApiManager googleApiManager = this;
                zaa<?> zaa5 = null;
                for (zaa<?> zaa6 : googleApiManager.zaih.values()) {
                    if (zaa6.getInstanceId() != n) continue;
                    zaa5 = zaa6;
                    break;
                }
                if (zaa5 != null) {
                    zaa<?> zaa6;
                    String string2 = googleApiManager.zaid.getErrorString(connectionResult.getErrorCode());
                    zaa6 = connectionResult.getErrorMessage();
                    zaa5.zac(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zaa6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zaa6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                GoogleApiManager googleApiManager = this;
                if (!PlatformVersion.isAtLeastIceCreamSandwich() || !(googleApiManager.zaic.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)((Application)googleApiManager.zaic.getApplicationContext()));
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabi(googleApiManager));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                googleApiManager.zaia = 300000L;
                break;
            }
            case 7: {
                this.zab((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zaih.containsKey(message.obj)) break;
                this.zaih.get(message.obj).resume();
                break;
            }
            case 10: {
                GoogleApiManager googleApiManager = this;
                for (zai<?> zai4 : googleApiManager.zaik) {
                    googleApiManager.zaih.remove(zai4).zabj();
                }
                googleApiManager.zaik.clear();
                break;
            }
            case 11: {
                if (!this.zaih.containsKey(message.obj)) break;
                this.zaih.get(message.obj).zaav();
                break;
            }
            case 12: {
                if (!this.zaih.containsKey(message.obj)) break;
                this.zaih.get(message.obj).zabp();
                break;
            }
            case 14: {
                zaaf zaaf2 = (zaaf)message.obj;
                GoogleApiManager googleApiManager = this;
                zai<?> zai5 = zaaf2.zak();
                if (!googleApiManager.zaih.containsKey(zai5)) {
                    zaaf2.zaal().setResult((Object)false);
                    break;
                }
                boolean bl = ((zaa)googleApiManager.zaih.get(zai5)).zac(false);
                zaaf2.zaal().setResult((Object)bl);
                break;
            }
            case 15: {
                zab zab2 = (zab)message.obj;
                if (!this.zaih.containsKey(zab2.zaja)) break;
                ((zaa)this.zaih.get(zab2.zaja)).zaa(zab2);
                break;
            }
            case 16: {
                zab zab3 = (zab)message.obj;
                if (!this.zaih.containsKey(zab3.zaja)) break;
                ((zaa)this.zaih.get(zab3.zaja)).zab(zab3);
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zaa(zai<?> zai2, int n) {
        zaa<?> zaa2 = this.zaih.get(zai2);
        if (zaa2 == null) {
            return null;
        }
        zad zad2 = zaa2.zabq();
        if (zad2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zaic, (int)n, (Intent)zad2.getSignInIntent(), (int)0x8000000);
    }

    final boolean zac(ConnectionResult connectionResult, int n) {
        return this.zaid.zaa(this.zaic, connectionResult, n);
    }

    public final void zaa(ConnectionResult connectionResult, int n) {
        if (!this.zac(connectionResult, n)) {
            this.handler.sendMessage(this.handler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    private static final class zab {
        private final zai<?> zaja;
        private final Feature zajb;

        private zab(zai<?> zai2, Feature feature) {
            this.zaja = zai2;
            this.zajb = feature;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof zab) {
                zab zab2 = (zab)object;
                return Objects.equal(this.zaja, zab2.zaja) && Objects.equal((Object)this.zajb, (Object)zab2.zajb);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zaja, this.zajb});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zaja).add("feature", (Object)this.zajb).toString();
        }

        /* synthetic */ zab(zai zai2, Feature feature, zabi zabi2) {
            this(zai2, feature);
        }
    }

    private final class zac
    implements zach,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zain;
        private final zai<?> zafp;
        private IAccountAccessor zajc = null;
        private Set<Scope> zajd = null;
        private boolean zaje = false;

        public zac(Api.Client client, zai<?> zai2) {
            this.zain = client;
            this.zafp = zai2;
        }

        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            GoogleApiManager.this.handler.post((Runnable)new zabo(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void zag(ConnectionResult connectionResult) {
            ((zaa)GoogleApiManager.this.zaih.get(this.zafp)).zag(connectionResult);
        }

        @Override
        @WorkerThread
        public final void zaa(IAccountAccessor iAccountAccessor, Set<Scope> set) {
            if (iAccountAccessor == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zag(new ConnectionResult(4));
                return;
            }
            this.zajc = iAccountAccessor;
            this.zajd = set;
            this.zabr();
        }

        @WorkerThread
        private final void zabr() {
            if (this.zaje && this.zajc != null) {
                this.zain.getRemoteService(this.zajc, this.zajd);
            }
        }

        static /* synthetic */ boolean zaa(zac zac2, boolean bl) {
            zac2.zaje = true;
            return true;
        }

        static /* synthetic */ Api.Client zaa(zac zac2) {
            return zac2.zain;
        }

        static /* synthetic */ void zab(zac zac2) {
            zac2.zabr();
        }

        static /* synthetic */ zai zac(zac zac2) {
            return zac2.zafp;
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zar {
        private final Queue<com.google.android.gms.common.api.internal.zab> zaim = new LinkedList<com.google.android.gms.common.api.internal.zab>();
        private final Api.Client zain;
        private final Api.AnyClient zaio;
        private final zai<O> zafp;
        private final zaab zaip;
        private final Set<zak> zaiq = new HashSet<zak>();
        private final Map<ListenerHolder.ListenerKey<?>, zabw> zair = new HashMap();
        private final int zais;
        private final zace zait;
        private boolean zaiu;
        private final List<zab> zaiv = new ArrayList<zab>();
        private ConnectionResult zaiw = null;

        @WorkerThread
        public zaa(GoogleApi<O> googleApi) {
            this.zain = googleApi.zaa(GoogleApiManager.this.handler.getLooper(), this);
            this.zaio = this.zain instanceof SimpleClientAdapter ? ((SimpleClientAdapter)this.zain).getClient() : this.zain;
            this.zafp = googleApi.zak();
            this.zaip = new zaab();
            this.zais = googleApi.getInstanceId();
            if (this.zain.requiresSignIn()) {
                this.zait = googleApi.zaa(GoogleApiManager.this.zaic, GoogleApiManager.this.handler);
                return;
            }
            this.zait = null;
        }

        @Override
        public final void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabg();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabj(this));
        }

        @WorkerThread
        private final void zabg() {
            this.zabl();
            this.zai(ConnectionResult.RESULT_SUCCESS);
            this.zabn();
            Iterator<zabw> iterator = this.zair.values().iterator();
            while (iterator.hasNext()) {
                zabw zabw2 = iterator.next();
                if (this.zaa(zabw2.zajw.getRequiredFeatures()) != null) {
                    iterator.remove();
                    continue;
                }
                try {
                    zabw2.zajw.registerListener(this.zaio, (TaskCompletionSource<Void>)new TaskCompletionSource());
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zain.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                    iterator.remove();
                }
            }
            this.zabi();
            this.zabo();
        }

        @Override
        public final void onConnectionSuspended(int n) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.zabh();
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabk(this));
        }

        @WorkerThread
        private final void zabh() {
            this.zabl();
            this.zaiu = true;
            this.zaip.zaai();
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zafp), GoogleApiManager.this.zahy);
            GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)11, this.zafp), GoogleApiManager.this.zahz);
            GoogleApiManager.this.zaie.flush();
        }

        @WorkerThread
        public final void zag(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zain.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final boolean zah(@NonNull ConnectionResult connectionResult) {
            Object object = lock;
            synchronized (object) {
                if (GoogleApiManager.this.zaii != null && GoogleApiManager.this.zaij.contains(this.zafp)) {
                    GoogleApiManager.this.zaii.zab(connectionResult, this.zais);
                    return true;
                }
                return false;
            }
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.handler.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.handler.post((Runnable)new zabl(this, connectionResult));
        }

        @Override
        @WorkerThread
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zait != null) {
                this.zait.zabs();
            }
            this.zabl();
            GoogleApiManager.this.zaie.flush();
            this.zai(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zac(zahx);
                return;
            }
            if (this.zaim.isEmpty()) {
                this.zaiw = connectionResult;
                return;
            }
            if (this.zah(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zac(connectionResult, this.zais)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaiu = true;
                }
                if (this.zaiu) {
                    GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.handler, (int)9, this.zafp), GoogleApiManager.this.zahy);
                    return;
                }
                String string2 = this.zafp.zan();
                this.zac(new Status(17, new StringBuilder(38 + String.valueOf(string2).length()).append("API: ").append(string2).append(" is not available on this device.").toString()));
            }
        }

        @WorkerThread
        private final void zabi() {
            ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zaim);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.api.internal.zab zab2 = arrayList.get(i);
                com.google.android.gms.common.api.internal.zab zab3 = zab2;
                if (!this.zain.isConnected()) break;
                if (!this.zab(zab3)) continue;
                this.zaim.remove(zab3);
            }
        }

        @WorkerThread
        public final void zaa(com.google.android.gms.common.api.internal.zab zab2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zain.isConnected()) {
                if (this.zab(zab2)) {
                    this.zabo();
                    return;
                }
                this.zaim.add(zab2);
                return;
            }
            this.zaim.add(zab2);
            if (this.zaiw != null && this.zaiw.hasResolution()) {
                this.onConnectionFailed(this.zaiw);
                return;
            }
            this.connect();
        }

        @WorkerThread
        public final void zabj() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zac(zahw);
            this.zaip.zaah();
            for (ListenerHolder.ListenerKey listenerKey : this.zair.keySet().toArray(new ListenerHolder.ListenerKey[this.zair.size()])) {
                this.zaa(new zah(listenerKey, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
            }
            this.zai(new ConnectionResult(4));
            if (this.zain.isConnected()) {
                this.zain.onUserSignOut(new zabm(this));
            }
        }

        public final Api.Client zaab() {
            return this.zain;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabw> zabk() {
            return this.zair;
        }

        @WorkerThread
        public final void zabl() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaiw = null;
        }

        @WorkerThread
        public final ConnectionResult zabm() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            return this.zaiw;
        }

        @WorkerThread
        private final boolean zab(com.google.android.gms.common.api.internal.zab zab2) {
            if (!(zab2 instanceof com.google.android.gms.common.api.internal.zac)) {
                this.zac(zab2);
                return true;
            }
            com.google.android.gms.common.api.internal.zac zac2 = (com.google.android.gms.common.api.internal.zac)zab2;
            Feature feature = this.zaa(zac2.zab(this));
            if (feature == null) {
                this.zac(zab2);
                return true;
            }
            if (zac2.zac(this)) {
                Feature feature2 = feature;
                zaa zaa2 = this;
                zab zab3 = new zab(zaa2.zafp, feature2, null);
                int n = zaa2.zaiv.indexOf(zab3);
                if (n >= 0) {
                    zab zab4 = zaa2.zaiv.get(n);
                    zaa2.GoogleApiManager.this.handler.removeMessages(15, (Object)zab4);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zab4), zaa2.GoogleApiManager.this.zahy);
                } else {
                    zaa2.zaiv.add(zab3);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)15, (Object)zab3), zaa2.GoogleApiManager.this.zahy);
                    zaa2.GoogleApiManager.this.handler.sendMessageDelayed(Message.obtain((Handler)zaa2.GoogleApiManager.this.handler, (int)16, (Object)zab3), zaa2.GoogleApiManager.this.zahz);
                    ConnectionResult connectionResult = new ConnectionResult(2, null);
                    if (!zaa2.zah(connectionResult)) {
                        zaa2.GoogleApiManager.this.zac(connectionResult, zaa2.zais);
                    }
                }
            } else {
                zac2.zaa((RuntimeException)new UnsupportedApiCallException(feature));
            }
            return false;
        }

        @WorkerThread
        private final void zac(com.google.android.gms.common.api.internal.zab zab2) {
            zab2.zaa(this.zaip, this.requiresSignIn());
            try {
                zab2.zaa(this);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zain.disconnect();
                return;
            }
        }

        @WorkerThread
        public final void zac(Status status) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            Iterator iterator = this.zaim.iterator();
            while (iterator.hasNext()) {
                ((com.google.android.gms.common.api.internal.zab)iterator.next()).zaa(status);
            }
            this.zaim.clear();
        }

        @WorkerThread
        public final void resume() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiu) {
                this.connect();
            }
        }

        @WorkerThread
        private final void zabn() {
            if (this.zaiu) {
                GoogleApiManager.this.handler.removeMessages(11, this.zafp);
                GoogleApiManager.this.handler.removeMessages(9, this.zafp);
                this.zaiu = false;
            }
        }

        @WorkerThread
        public final void zaav() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zaiu) {
                this.zabn();
                Status status = GoogleApiManager.this.zaid.isGooglePlayServicesAvailable(GoogleApiManager.this.zaic) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zac(status);
                this.zain.disconnect();
            }
        }

        private final void zabo() {
            GoogleApiManager.this.handler.removeMessages(12, this.zafp);
            GoogleApiManager.this.handler.sendMessageDelayed(GoogleApiManager.this.handler.obtainMessage(12, this.zafp), GoogleApiManager.this.zaia);
        }

        @WorkerThread
        public final boolean zabp() {
            return this.zac(true);
        }

        @WorkerThread
        private final boolean zac(boolean bl) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zain.isConnected() && this.zair.size() == 0) {
                if (this.zaip.zaag()) {
                    if (bl) {
                        this.zabo();
                    }
                    return false;
                }
                this.zain.disconnect();
                return true;
            }
            return false;
        }

        @WorkerThread
        public final void connect() {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            if (this.zain.isConnected() || this.zain.isConnecting()) {
                return;
            }
            int n = GoogleApiManager.this.zaie.getClientAvailability(GoogleApiManager.this.zaic, this.zain);
            if (n != 0) {
                ConnectionResult connectionResult = new ConnectionResult(n, null);
                this.onConnectionFailed(connectionResult);
                return;
            }
            zac zac2 = new zac(this.zain, this.zafp);
            if (this.zain.requiresSignIn()) {
                this.zait.zaa(zac2);
            }
            this.zain.connect(zac2);
        }

        @WorkerThread
        public final void zaa(zak zak2) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.this.handler);
            this.zaiq.add(zak2);
        }

        @WorkerThread
        private final void zai(ConnectionResult connectionResult) {
            for (zak zak2 : this.zaiq) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zain.getEndpointPackageName();
                }
                zak2.zaa(this.zafp, connectionResult, string2);
            }
            this.zaiq.clear();
        }

        final boolean isConnected() {
            return this.zain.isConnected();
        }

        public final boolean requiresSignIn() {
            return this.zain.requiresSignIn();
        }

        public final int getInstanceId() {
            return this.zais;
        }

        final zad zabq() {
            if (this.zait == null) {
                return null;
            }
            return this.zait.zabq();
        }

        @WorkerThread
        @Nullable
        private final Feature zaa(@Nullable Feature[] featureArray) {
            Feature feature;
            int n;
            if (featureArray == null || featureArray.length == 0) {
                return null;
            }
            Feature[] featureArray2 = this.zain.getAvailableFeatures();
            if (featureArray2 == null) {
                featureArray2 = new Feature[]{};
            }
            ArrayMap arrayMap = new ArrayMap(featureArray2.length);
            Feature[] featureArray3 = featureArray2;
            int n2 = featureArray2.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                arrayMap.put(feature.getName(), feature.getVersion());
            }
            featureArray3 = featureArray;
            n2 = featureArray.length;
            for (n = 0; n < n2; ++n) {
                feature = featureArray3[n];
                if (arrayMap.containsKey(feature.getName()) && (Long)arrayMap.get(feature.getName()) >= feature.getVersion()) continue;
                return feature;
            }
            return null;
        }

        @WorkerThread
        private final void zaa(zab zab2) {
            if (!this.zaiv.contains(zab2)) {
                return;
            }
            if (!this.zaiu) {
                if (!this.zain.isConnected()) {
                    this.connect();
                    return;
                }
                this.zabi();
            }
        }

        @WorkerThread
        private final void zab(zab zab2) {
            if (this.zaiv.remove(zab2)) {
                GoogleApiManager.this.handler.removeMessages(15, (Object)zab2);
                GoogleApiManager.this.handler.removeMessages(16, (Object)zab2);
                Feature feature = zab2.zajb;
                zaa zaa2 = this;
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(zaa2.zaim.size());
                for (com.google.android.gms.common.api.internal.zab zab3 : zaa2.zaim) {
                    Object[] objectArray;
                    if (!(zab3 instanceof com.google.android.gms.common.api.internal.zac) || (objectArray = ((com.google.android.gms.common.api.internal.zac)zab3).zab(zaa2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                    arrayList.add(zab3);
                }
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList2 = arrayList;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.api.internal.zab zab3;
                    Object e = arrayList2.get(i);
                    zab3 = (com.google.android.gms.common.api.internal.zab)e;
                    zaa2.zaim.remove(zab3);
                    zab3.zaa((RuntimeException)new UnsupportedApiCallException(feature));
                }
            }
        }

        static /* synthetic */ void zae(zaa zaa2) {
            zaa2.zabg();
        }

        static /* synthetic */ void zaf(zaa zaa2) {
            zaa2.zabh();
        }

        static /* synthetic */ Api.Client zag(zaa zaa2) {
            return zaa2.zain;
        }
    }
}

