/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Preconditions;

public class GoogleApiAvailabilityCache {
    private final SparseIntArray zaor = new SparseIntArray();
    private GoogleApiAvailabilityLight zaos;

    public GoogleApiAvailabilityCache() {
        this(GoogleApiAvailability.getInstance());
    }

    public GoogleApiAvailabilityCache(@NonNull GoogleApiAvailabilityLight googleApiAvailabilityLight) {
        Preconditions.checkNotNull((Object)googleApiAvailabilityLight);
        this.zaos = googleApiAvailabilityLight;
    }

    public int getClientAvailability(@NonNull Context context, @NonNull Api.Client client) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)client);
        if (!client.requiresGooglePlayServices()) {
            return 0;
        }
        int n = client.getMinApkVersion();
        int n2 = this.zaor.get(n, -1);
        if (n2 != -1) {
            return n2;
        }
        for (int i = 0; i < this.zaor.size(); ++i) {
            int n3 = this.zaor.keyAt(i);
            if (n3 <= n || this.zaor.get(n3) != 0) continue;
            n2 = 0;
            break;
        }
        if (n2 == -1) {
            n2 = this.zaos.isGooglePlayServicesAvailable(context, n);
        }
        this.zaor.put(n, n2);
        return n2;
    }

    public void flush() {
        this.zaor.clear();
    }
}

