/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzba;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzx;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzak = TimeUnit.HOURS.toSeconds(8L);
    private static zzaw zzal;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzam;
    private final Executor zzan;
    private final FirebaseApp zzao;
    private final zzan zzap;
    private MessagingChannel zzaq;
    private final zzaq zzar;
    private final zzba zzas;
    @GuardedBy(value="this")
    private boolean zzat = false;
    private final zza zzau;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber) {
        this(firebaseApp, new zzan(firebaseApp.getApplicationContext()), zzi.zzg(), zzi.zzg(), subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzan zzan2, Executor executor, Executor executor2, Subscriber subscriber) {
        if (com.google.firebase.iid.zzan.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzal == null) {
                zzal = new zzaw(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.zzao = firebaseApp;
            this.zzap = zzan2;
            Executor executor3 = executor;
            zzan zzan3 = zzan2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzaq == null) {
                MessagingChannel messagingChannel = (MessagingChannel)firebaseApp2.get(MessagingChannel.class);
                firebaseInstanceId.zzaq = messagingChannel != null && messagingChannel.isAvailable() ? messagingChannel : new zzr(firebaseApp2, zzan3, executor3);
            }
            this.zzaq = firebaseInstanceId.zzaq;
            this.zzan = executor2;
            this.zzas = new zzba(zzal);
            this.zzau = new zza(subscriber);
            this.zzar = new zzaq(executor);
            if (this.zzau.isEnabled()) {
                this.zzh();
            }
            return;
        }
    }

    private final void zzh() {
        zzax zzax2 = this.zzk();
        if (this.zzr() || this.zza(zzax2) || this.zzas.zzap()) {
            this.startSync();
        }
    }

    final FirebaseApp zzi() {
        return this.zzao;
    }

    final synchronized void zza(boolean bl) {
        this.zzat = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzat) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzak);
        FirebaseInstanceId.zza(new zzay(this, this.zzap, this.zzas, l2), l);
        this.zzat = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzam == null) {
                zzam = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzam.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzh();
        return FirebaseInstanceId.zzj();
    }

    private static String zzj() {
        return com.google.firebase.iid.zzan.zza(zzal.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzal.zzg("").getCreationTime();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(com.google.firebase.iid.zzan.zza(this.zzao), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        return Tasks.forResult(null).continueWithTask(this.zzan, (Continuation)new zzn(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzj();
        this.zza(this.zzaq.deleteInstanceId(string));
        this.zzn();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzax zzax2 = this.zzk();
        if (this.zzaq.needsRefresh() || this.zza(zzax2)) {
            this.startSync();
        }
        return zzax.zzb(zzax2);
    }

    @Nullable
    final zzax zzk() {
        return FirebaseInstanceId.zzb(com.google.firebase.iid.zzan.zza(this.zzao), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzax zzb(String string, String string2) {
        return zzal.zzb("", string, string2);
    }

    final String zzl() throws IOException {
        return this.getToken(com.google.firebase.iid.zzan.zza(this.zzao), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzn();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzj();
        String string4 = zzax.zzb(FirebaseInstanceId.zzb(string, string2));
        this.zza(this.zzaq.deleteToken(string3, string4, string, string2));
        zzal.zzc("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzas.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzax zzax2 = this.zzk();
        if (this.zza(zzax2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzj();
        String string3 = string;
        String string4 = zzax2.zzbr;
        String string5 = string2;
        Task<Void> task = this.zzaq.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzax zzax2 = this.zzk();
        if (this.zza(zzax2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzj();
        this.zza(this.zzaq.unsubscribeFromTopic(string2, zzax2.zzbr, string));
    }

    static boolean zzm() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzn() {
        zzal.zzal();
        if (this.zzau.isEnabled()) {
            this.startSync();
        }
    }

    final boolean zzo() {
        return this.zzaq.isAvailable();
    }

    final void zzp() {
        zzal.zzh("");
        this.startSync();
    }

    @VisibleForTesting
    public final boolean zzq() {
        return this.zzau.isEnabled();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzau.setEnabled(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final boolean zza(@Nullable zzax zzax2) {
        return zzax2 == null || zzax2.zzj(this.zzap.zzad());
    }

    final boolean zzr() {
        return this.zzaq.needsRefresh();
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = FirebaseInstanceId.zzj();
        zzax zzax2 = FirebaseInstanceId.zzb(string, string2);
        if (!this.zzaq.needsRefresh() && !this.zza(zzax2)) {
            return Tasks.forResult((Object)new zzx(string3, zzax2.zzbr));
        }
        String string4 = zzax.zzb(zzax2);
        return this.zzar.zza(string, string2, new zzo(this, string3, string4, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) {
        return this.zzaq.getToken(string, string2, string3, string4).onSuccessTask(this.zzan, (SuccessContinuation)new zzp(this, string3, string4, string));
    }

    final /* synthetic */ Task zzb(String string, String string2, String string3, String string4) throws Exception {
        zzal.zza("", string, string2, string4, this.zzap.zzad());
        return Tasks.forResult((Object)new zzx(string3, string4));
    }

    private final class zza {
        private final boolean zzba;
        private final Subscriber zzbb;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zzbc;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzbd;

        zza(Subscriber subscriber) {
            this.zzbb = subscriber;
            this.zzba = this.zzu();
            this.zzbd = this.zzt();
            if (this.zzbd == null && this.zzba) {
                this.zzbc = new zzq(this);
                subscriber.subscribe(DataCollectionDefaultChange.class, this.zzbc);
            }
        }

        final synchronized boolean isEnabled() {
            if (this.zzbd != null) {
                return this.zzbd;
            }
            return this.zzba && FirebaseInstanceId.this.zzao.isDataCollectionDefaultEnabled();
        }

        final synchronized void setEnabled(boolean bl) {
            if (this.zzbc != null) {
                this.zzbb.unsubscribe(DataCollectionDefaultChange.class, this.zzbc);
                this.zzbc = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zzao.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzh();
            }
            this.zzbd = bl;
        }

        @Nullable
        private final Boolean zzt() {
            Context context = FirebaseInstanceId.this.zzao.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzu() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zzao.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

