/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.io.File;
import java.io.IOException;
import java.util.Map;

final class zzaw {
    private final SharedPreferences zzde;
    private final Context zzz;
    private final zzy zzdf;
    @GuardedBy(value="this")
    private final Map<String, zzz> zzdg;

    public zzaw(Context context) {
        this(context, new zzy());
    }

    private zzaw(Context context, zzy zzy2) {
        block4: {
            this.zzdg = new ArrayMap();
            this.zzz = context;
            this.zzde = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzdf = zzy2;
            String string = "com.google.android.gms.appid-no-backup";
            zzaw zzaw2 = this;
            File file = ContextCompat.getNoBackupFilesDir((Context)zzaw2.zzz);
            File file2 = new File(file, string);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzaw2.isEmpty()) {
                        Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
                        zzaw2.zzal();
                        FirebaseInstanceId.getInstance().zzn();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block4;
                    String string2 = String.valueOf(iOException.getMessage());
                    Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final synchronized String zzak() {
        return this.zzde.getString("topic_operaion_queue", "");
    }

    public final synchronized void zzf(String string) {
        this.zzde.edit().putString("topic_operaion_queue", string).apply();
    }

    private final synchronized boolean isEmpty() {
        return this.zzde.getAll().isEmpty();
    }

    private static String zza(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    static String zzd(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public final synchronized void zzal() {
        this.zzdg.clear();
        zzy.zza(this.zzz);
        this.zzde.edit().clear().commit();
    }

    public final synchronized zzax zzb(String string, String string2, String string3) {
        return zzax.zzi(this.zzde.getString(zzaw.zza(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzax.zza(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zzde.edit();
        editor.putString(zzaw.zza(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzc(String string, String string2, String string3) {
        String string4 = zzaw.zza(string, string2, string3);
        SharedPreferences.Editor editor = this.zzde.edit();
        editor.remove(string4);
        editor.commit();
    }

    public final synchronized zzz zzg(String string) {
        zzz zzz2 = this.zzdg.get(string);
        if (zzz2 != null) {
            return zzz2;
        }
        try {
            zzz2 = this.zzdf.zzb(this.zzz, string);
        }
        catch (zzaa zzaa2) {
            Log.w((String)"FirebaseInstanceId", (String)"Stored data is corrupt, generating new identity");
            FirebaseInstanceId.getInstance().zzn();
            zzz2 = this.zzdf.zzc(this.zzz, string);
        }
        this.zzdg.put(string, zzz2);
        return zzz2;
    }

    public final synchronized void zzh(String string) {
        String string2 = String.valueOf(string).concat("|T|");
        zzaw zzaw2 = this;
        SharedPreferences.Editor editor = zzaw2.zzde.edit();
        for (String string3 : zzaw2.zzde.getAll().keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }
}

