/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zzf;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public final class zzh
implements ServiceConnection {
    private final Context zzz;
    private final Intent zzaa;
    private final ScheduledExecutorService zzab;
    private final Queue<zzd> zzac = new ArrayDeque<zzd>();
    private zzf zzad;
    @GuardedBy(value="this")
    private boolean zzae = false;

    public zzh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    private zzh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzz = context.getApplicationContext();
        this.zzaa = new Intent(string).setPackage(this.zzz.getPackageName());
        this.zzab = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzac.add(new zzd(intent, pendingResult, this.zzab));
        this.zzd();
    }

    private final synchronized void zzd() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzac.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzad != null && this.zzad.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzd zzd2 = this.zzac.poll();
                this.zzad.zza(zzd2);
                continue;
            }
            zzh zzh2 = this;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !zzh2.zzae;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzh2.zzae) {
                zzh2.zzae = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzh2.zzz, zzh2.zzaa, (ServiceConnection)zzh2, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzh2.zzae = false;
                zzh2.zze();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zze() {
        while (!this.zzac.isEmpty()) {
            this.zzac.poll().finish();
        }
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.zzae = false;
        if (!(iBinder instanceof zzf)) {
            string = String.valueOf(iBinder);
            Log.e((String)"EnhancedIntentService", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.zze();
            return;
        }
        this.zzad = (zzf)iBinder;
        this.zzd();
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzd();
    }
}

