/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzb;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseMessagingService
extends zzb {
    private static final Queue<String> zzdt = new ArrayDeque<String>(10);

    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string) {
    }

    @WorkerThread
    public void onSendError(String string, Exception exception) {
    }

    @WorkerThread
    public void onNewToken(String string) {
    }

    protected final Intent zzb(Intent intent) {
        return zzav.zzai().zzaj();
    }

    public final boolean zzc(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (MessagingAnalytics.shouldUploadMetrics(intent2)) {
                MessagingAnalytics.logNotificationOpen(intent2);
            }
            return true;
        }
        return false;
    }

    public final void zzd(Intent intent) {
        String string2 = intent.getAction();
        if ("com.google.android.c2dm.intent.RECEIVE".equals(string2) || "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(string2)) {
            boolean bl;
            Object object;
            Task task;
            String string3;
            Intent intent2 = intent;
            FirebaseMessagingService firebaseMessagingService = this;
            String string4 = string3 = intent2.getStringExtra("google.message_id");
            Object object2 = firebaseMessagingService;
            if (TextUtils.isEmpty((CharSequence)string4)) {
                task = Tasks.forResult(null);
            } else {
                object = new Bundle();
                object.putString("google.message_id", string4);
                task = zzab.zzc((Context)object2).zza(2, object);
            }
            Task task2 = task;
            object2 = string3;
            if (TextUtils.isEmpty((CharSequence)object2)) {
                bl = false;
            } else if (zzdt.contains(object2)) {
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    String string5 = String.valueOf(object2);
                    Log.d((String)"FirebaseMessaging", (String)(string5.length() != 0 ? "Received duplicate message: ".concat(string5) : new String("Received duplicate message: ")));
                }
                bl = true;
            } else {
                if (zzdt.size() >= 10) {
                    zzdt.remove();
                }
                zzdt.add((String)object2);
                bl = false;
            }
            if (!bl) {
                string4 = intent2;
                object2 = firebaseMessagingService;
                object = string4.getStringExtra("message_type");
                if (object == null) {
                    object = "gcm";
                }
                switch (object) {
                    case "gcm": {
                        if (MessagingAnalytics.shouldUploadMetrics((Intent)string4)) {
                            MessagingAnalytics.logNotificationReceived((Intent)string4);
                        }
                        String string6 = string4;
                        Object object3 = object2;
                        Bundle bundle = string6.getExtras();
                        if (bundle == null) {
                            bundle = new Bundle();
                        }
                        bundle.remove("androidx.contentpager.content.wakelockid");
                        if (zza.zzf(bundle)) {
                            if (new zza((Context)object3).zzh(bundle)) break;
                            if (MessagingAnalytics.shouldUploadMetrics((Intent)string6)) {
                                MessagingAnalytics.logNotificationForeground((Intent)string6);
                            }
                        }
                        ((FirebaseMessagingService)((Object)object3)).onMessageReceived(new RemoteMessage(bundle));
                        break;
                    }
                    case "deleted_messages": {
                        ((FirebaseMessagingService)((Object)object2)).onDeletedMessages();
                        break;
                    }
                    case "send_event": {
                        ((FirebaseMessagingService)((Object)object2)).onMessageSent(string4.getStringExtra("google.message_id"));
                        break;
                    }
                    case "send_error": {
                        String string7 = string4;
                        String string8 = string7.getStringExtra("google.message_id");
                        if (string8 == null) {
                            string8 = string7.getStringExtra("message_id");
                        }
                        ((FirebaseMessagingService)((Object)object2)).onSendError(string8, new SendException(string4.getStringExtra("error")));
                        break;
                    }
                    default: {
                        String string9 = String.valueOf(object);
                        Log.w((String)"FirebaseMessaging", (String)(string9.length() != 0 ? "Received message with unknown type: ".concat(string9) : new String("Received message with unknown type: ")));
                    }
                }
            }
            try {
                Tasks.await((Task)task2, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                String string10 = String.valueOf(exception);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(20 + String.valueOf(string10).length()).append("Message ack failed: ").append(string10).toString());
                return;
            }
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(string2)) {
            if (MessagingAnalytics.shouldUploadMetrics(intent)) {
                MessagingAnalytics.logNotificationDismiss(intent);
                return;
            }
        } else {
            if ("com.google.firebase.messaging.NEW_TOKEN".equals(string2)) {
                this.onNewToken(intent.getStringExtra("token"));
                return;
            }
            String string11 = String.valueOf(intent.getAction());
            Log.d((String)"FirebaseMessaging", (String)(string11.length() != 0 ? "Unknown intent action: ".concat(string11) : new String("Unknown intent action: ")));
        }
    }

    static void zzj(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }
}

