/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzb;
import com.google.firebase.messaging.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzc();
    @SafeParcelable.Field(id=2)
    Bundle zzdu;
    private Map<String, String> zzdv;
    private Notification zzdw;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.zzdu = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)remoteMessage.zzdu, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.zzdu.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.zzdu.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdv == null) {
            Bundle bundle = this.zzdu;
            ArrayMap arrayMap = new ArrayMap();
            for (String string2 : bundle.keySet()) {
                Object object = bundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                arrayMap.put((Object)string2, (Object)string3);
            }
            this.zzdv = arrayMap;
        }
        return this.zzdv;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zzdu.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.zzdu.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zzdu.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.zzdu.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.zzdu.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.zzdu.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string2 = this.zzdu.getString("google.original_priority");
        if (string2 == null) {
            string2 = this.zzdu.getString("google.priority");
        }
        return RemoteMessage.zzm(string2);
    }

    public final int getPriority() {
        String string2 = this.zzdu.getString("google.delivered_priority");
        if (string2 == null) {
            if ("1".equals(this.zzdu.getString("google.priority_reduced"))) {
                return 2;
            }
            string2 = this.zzdu.getString("google.priority");
        }
        return RemoteMessage.zzm(string2);
    }

    private static int zzm(String string2) {
        if ("high".equals(string2)) {
            return 1;
        }
        if ("normal".equals(string2)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzdw == null && zza.zzf(this.zzdu)) {
            this.zzdw = new Notification(this.zzdu, null);
        }
        return this.zzdw;
    }

    @KeepForSdk
    public final Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.zzdu);
        return intent;
    }

    public static class Notification {
        private final String zzdx;
        private final String zzdy;
        private final String[] zzdz;
        private final String zzea;
        private final String zzeb;
        private final String[] zzec;
        private final String zzed;
        private final String zzee;
        private final String tag;
        private final String zzef;
        private final String zzeg;
        private final String zzeh;
        private final Uri zzei;

        private Notification(Bundle bundle) {
            this.zzdx = zza.zza(bundle, "gcm.n.title");
            this.zzdy = zza.zzb(bundle, "gcm.n.title");
            this.zzdz = Notification.zze(bundle, "gcm.n.title");
            this.zzea = zza.zza(bundle, "gcm.n.body");
            this.zzeb = zza.zzb(bundle, "gcm.n.body");
            this.zzec = Notification.zze(bundle, "gcm.n.body");
            this.zzed = zza.zza(bundle, "gcm.n.icon");
            this.zzee = zza.zzi(bundle);
            this.tag = zza.zza(bundle, "gcm.n.tag");
            this.zzef = zza.zza(bundle, "gcm.n.color");
            this.zzeg = zza.zza(bundle, "gcm.n.click_action");
            this.zzeh = zza.zza(bundle, "gcm.n.android_channel_id");
            this.zzei = zza.zzg(bundle);
        }

        private static String[] zze(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzc(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzdx;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzdy;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzdz;
        }

        @Nullable
        public String getBody() {
            return this.zzea;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzeb;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzec;
        }

        @Nullable
        public String getIcon() {
            return this.zzed;
        }

        @Nullable
        public String getSound() {
            return this.zzee;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.zzef;
        }

        @Nullable
        public String getClickAction() {
            return this.zzeg;
        }

        @Nullable
        public String getChannelId() {
            return this.zzeh;
        }

        @Nullable
        public Uri getLink() {
            return this.zzei;
        }

        /* synthetic */ Notification(Bundle bundle, zzb zzb2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle zzdu = new Bundle();
        private final Map<String, String> zzdv = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zzdu.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdv.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzdu);
            this.zzdu.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdv.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdv.clear();
            this.zzdv.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdv.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zzdu.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zzdu.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.zzdu.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zzdu.putString("collapse_key", string2);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

