/*
 * Decompiled with CFR 0.152.
 */
package bolts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import bolts.AppLinks;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MeasurementEvent {
    public static final String MEASUREMENT_EVENT_NOTIFICATION_NAME = "com.parse.bolts.measurement_event";
    public static final String MEASUREMENT_EVENT_NAME_KEY = "event_name";
    public static final String MEASUREMENT_EVENT_ARGS_KEY = "event_args";
    public static final String APP_LINK_NAVIGATE_OUT_EVENT_NAME = "al_nav_out";
    public static final String APP_LINK_NAVIGATE_IN_EVENT_NAME = "al_nav_in";
    private Context appContext;
    private String name;
    private Bundle args;

    static void sendBroadcastEvent(Context context, String name, Intent intent, Map<String, String> extraLoggingData) {
        Bundle logData = new Bundle();
        if (intent != null) {
            Bundle applinkData = AppLinks.getAppLinkData(intent);
            if (applinkData != null) {
                logData = MeasurementEvent.getApplinkLogData(context, name, applinkData, intent);
            } else {
                Bundle intentExtras;
                Uri intentUri = intent.getData();
                if (intentUri != null) {
                    logData.putString("intentData", intentUri.toString());
                }
                if ((intentExtras = intent.getExtras()) != null) {
                    for (String key : intentExtras.keySet()) {
                        Object o = intentExtras.get(key);
                        String logValue = MeasurementEvent.objectToJSONString(o);
                        logData.putString(key, logValue);
                    }
                }
            }
        }
        if (extraLoggingData != null) {
            for (String key : extraLoggingData.keySet()) {
                logData.putString(key, extraLoggingData.get(key));
            }
        }
        MeasurementEvent event = new MeasurementEvent(context, name, logData);
        event.sendBroadcast();
    }

    private MeasurementEvent(Context context, String eventName, Bundle eventArgs) {
        this.appContext = context.getApplicationContext();
        this.name = eventName;
        this.args = eventArgs;
    }

    private void sendBroadcast() {
        if (this.name == null) {
            Log.d((String)this.getClass().getName(), (String)"Event name is required");
        }
        try {
            Class<?> clazz = Class.forName("androidx.localbroadcastmanager.content.LocalBroadcastManager");
            Method methodGetInstance = clazz.getMethod("getInstance", Context.class);
            Method methodSendBroadcast = clazz.getMethod("sendBroadcast", Intent.class);
            Object localBroadcastManager = methodGetInstance.invoke(null, this.appContext);
            Intent event = new Intent(MEASUREMENT_EVENT_NOTIFICATION_NAME);
            event.putExtra(MEASUREMENT_EVENT_NAME_KEY, this.name);
            event.putExtra(MEASUREMENT_EVENT_ARGS_KEY, this.args);
            methodSendBroadcast.invoke(localBroadcastManager, event);
        }
        catch (Exception e) {
            Log.d((String)this.getClass().getName(), (String)"LocalBroadcastManager in android support library is required to raise bolts event.");
        }
    }

    private static Bundle getApplinkLogData(Context context, String eventName, Bundle appLinkData, Intent applinkIntent) {
        Bundle logData = new Bundle();
        ComponentName resolvedActivity = applinkIntent.resolveActivity(context.getPackageManager());
        if (resolvedActivity != null) {
            logData.putString("class", resolvedActivity.getShortClassName());
        }
        if (APP_LINK_NAVIGATE_OUT_EVENT_NAME.equals(eventName)) {
            if (resolvedActivity != null) {
                logData.putString("package", resolvedActivity.getPackageName());
            }
            if (applinkIntent.getData() != null) {
                logData.putString("outputURL", applinkIntent.getData().toString());
            }
            if (applinkIntent.getScheme() != null) {
                logData.putString("outputURLScheme", applinkIntent.getScheme());
            }
        } else if (APP_LINK_NAVIGATE_IN_EVENT_NAME.equals(eventName)) {
            if (applinkIntent.getData() != null) {
                logData.putString("inputURL", applinkIntent.getData().toString());
            }
            if (applinkIntent.getScheme() != null) {
                logData.putString("inputURLScheme", applinkIntent.getScheme());
            }
        }
        for (String key : appLinkData.keySet()) {
            Object o = appLinkData.get(key);
            if (o instanceof Bundle) {
                for (String subKey : ((Bundle)o).keySet()) {
                    String logValue = MeasurementEvent.objectToJSONString(((Bundle)o).get(subKey));
                    if (key.equals("referer_app_link")) {
                        if (subKey.equalsIgnoreCase("url")) {
                            logData.putString("refererURL", logValue);
                            continue;
                        }
                        if (subKey.equalsIgnoreCase("app_name")) {
                            logData.putString("refererAppName", logValue);
                            continue;
                        }
                        if (subKey.equalsIgnoreCase("package")) {
                            logData.putString("sourceApplication", logValue);
                            continue;
                        }
                    }
                    logData.putString(key + "/" + subKey, logValue);
                }
                continue;
            }
            String logValue = MeasurementEvent.objectToJSONString(o);
            if (key.equals("target_url")) {
                Uri targetURI = Uri.parse((String)logValue);
                logData.putString("targetURL", targetURI.toString());
                logData.putString("targetURLHost", targetURI.getHost());
                continue;
            }
            logData.putString(key, logValue);
        }
        return logData;
    }

    private static String objectToJSONString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONArray || o instanceof JSONObject) {
            return o.toString();
        }
        try {
            if (o instanceof Collection) {
                return new JSONArray((Collection)o).toString();
            }
            if (o instanceof Map) {
                return new JSONObject((Map)o).toString();
            }
            return o.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

