/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.devtodev.core.utils.SessionInformation;
import com.unity3d.player.UnityPlayer;

class DTDApplicationLifecycle
implements Application.ActivityLifecycleCallbacks {
    private SessionInformation sessionUtils;
    private int running;

    DTDApplicationLifecycle(String projectId, String userId) {
        ++this.running;
        this.sessionUtils = new SessionInformation(projectId, userId);
        final Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e2) {
                DTDApplicationLifecycle.this.sessionUtils.writeLostSessionNative();
                defaultHandler.uncaughtException(t, e2);
            }
        });
    }

    SessionInformation getSessionUtils() {
        return this.sessionUtils;
    }

    boolean isRunning() {
        return this.running > 0;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        try {
            UnityPlayer.UnitySendMessage((String)"[devtodev_AsyncOperationDispatcher]", (String)"StartSession", (String)"StartSession");
        }
        catch (Error error) {
            // empty catch block
        }
        ++this.running;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        this.sessionUtils.writeLostSessionNative();
    }

    public void onActivityStopped(Activity activity) {
        try {
            UnityPlayer.UnitySendMessage((String)"[devtodev_AsyncOperationDispatcher]", (String)"EndSession", (String)String.valueOf(System.currentTimeMillis() / 1000L));
        }
        catch (Error error) {
            // empty catch block
        }
        --this.running;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.sessionUtils.removeLostSessionNative();
    }
}

