/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.data.metrics;

import com.devtodev.core.data.metrics.JSONable;
import com.devtodev.core.data.metrics.MetricConsts;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Metric
implements JSONable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TAG = Metric.class.getSimpleName();
    protected static final String TIMESTAMP_KEY = "timestamp";
    protected String name;
    private String code;
    private HashMap<String, Object> parameters;

    protected Metric(String metricName, String metricCode) {
        this.name = metricName;
        this.code = metricCode;
        this.parameters = new HashMap();
    }

    public void addParameter(String key, Object value) {
        if (value instanceof String) {
            try {
                value = URLEncoder.encode(value.toString(), "UTF-8");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.parameters.put(key, value);
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getMetricCode() {
        return this.code;
    }

    public String getMetricName() {
        return this.name;
    }

    protected boolean addValueIfConsist(String key, JSONObject object) throws JSONException {
        Object value = this.parameters.get(key);
        if (value != null) {
            object.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject();
    }

    public String toString() {
        return "Metric{name='" + this.name + '\'' + ", code='" + this.code + '\'' + ", parameters=" + this.parameters + '}';
    }

    public boolean isFastSend() {
        return Arrays.asList(MetricConsts.fastSendMetrics).contains(this.code);
    }
}

