/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import android.os.AsyncTask;
import com.devtodev.core.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

class CoreAsyncTask
extends AsyncTask<Request, Object, Boolean> {
    private OnRequestSend onRequestSend;

    CoreAsyncTask(OnRequestSend onRequestSend) {
        this.onRequestSend = onRequestSend;
    }

    protected Boolean doInBackground(Request ... requests) {
        Request request = requests[0];
        return this.makeRequest(request);
    }

    protected void onPostExecute(Boolean result) {
        super.onPostExecute((Object)result);
        Logger.d("OnPostExecute: " + result);
        if (this.onRequestSend != null) {
            this.onRequestSend.OnSend(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeRequest(Request request) {
        boolean response = false;
        HttpURLConnection urlConnection = null;
        OutputStream outputStream = null;
        try {
            URL url = new URL(request.getUrl());
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setDoOutput(true);
            outputStream = urlConnection.getOutputStream();
            outputStream.write(request.getZippedPostData());
            outputStream.flush();
            outputStream.close();
            response = urlConnection.getResponseCode() == 200;
            Logger.d("Url: " + request.getUrl() + "\nPost: " + request.getData() + "\nCode: " + urlConnection.getResponseCode());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            response = false;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        return response;
    }

    static interface OnRequestSend {
        public void OnSend(boolean var1);
    }

    static class Request {
        private String url;
        private String data;

        Request(String url, String data) {
            this.data = data;
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getData() {
            return this.data;
        }

        byte[] getZippedPostData() {
            byte[] zippedData = this.data.getBytes();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(os);
                gzip.write(this.data.getBytes());
                gzip.flush();
                gzip.close();
                zippedData = os.toByteArray();
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return zippedData;
        }
    }
}

