/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import com.devtodev.core.utils.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;

public class DecompressibleInputStream
extends ObjectInputStream {
    public DecompressibleInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> localClass;
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        try {
            localClass = Class.forName(resultClassDescriptor.getName());
        }
        catch (ClassNotFoundException e2) {
            Logger.d("No local class for " + resultClassDescriptor.getName(), e2);
            return resultClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long streamSUID = resultClassDescriptor.getSerialVersionUID();
            if (streamSUID != localSUID) {
                try {
                    Method method = ObjectStreamClass.class.getDeclaredMethod("setSerialVersionUID", Long.TYPE);
                    method.setAccessible(true);
                    method.invoke((Object)resultClassDescriptor, localSUID);
                }
                catch (Exception e3) {
                    Logger.d("Potentially Fatal Deserialization Operation.", e3);
                }
            }
        }
        return resultClassDescriptor;
    }
}

