/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.devtodev.core.utils.Logger;
import com.devtodev.core.utils.Root;
import com.unity3d.player.UnityPlayer;

public class DeviceUtils {
    public static String getUserAgent() {
        String userAgent = System.getProperty("http.agent");
        if (userAgent != null) {
            return userAgent;
        }
        return "";
    }

    public static boolean isRoot() {
        return Root.isDeviceRooted();
    }

    public static String getHardwareToken() {
        String serial = Build.SERIAL;
        if (serial != null) {
            return serial;
        }
        return "";
    }

    public static String getAndroidID() {
        String androidId = Settings.Secure.getString((ContentResolver)UnityPlayer.currentActivity.getContentResolver(), (String)"android_id");
        if (androidId != null) {
            return androidId;
        }
        return "";
    }

    public static int mobileOperator() {
        if (UnityPlayer.currentActivity.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager manager = (TelephonyManager)UnityPlayer.currentActivity.getSystemService("phone");
            try {
                return Integer.parseInt(manager.getNetworkOperator());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return 0;
    }

    public static int getScreenResolutionMax() {
        Point resolution = DeviceUtils.getScreenResolution((Context)UnityPlayer.currentActivity);
        return Math.max(resolution.x, resolution.y);
    }

    public static int getScreenResolutionMin() {
        Point resolution = DeviceUtils.getScreenResolution((Context)UnityPlayer.currentActivity);
        return Math.min(resolution.x, resolution.y);
    }

    private static Point getScreenResolution(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            Point size = new Point();
            display.getRealSize(size);
            return size;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return new Point(metrics.widthPixels, metrics.heightPixels);
    }

    public static float getScreenDpi() {
        WindowManager wm = UnityPlayer.currentActivity.getWindowManager();
        if (wm == null) {
            Logger.e("Error get screen DPI. Windows manager is null");
            return 0.0f;
        }
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return (metrics.xdpi + metrics.ydpi) * 0.5f;
    }
}

