/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import android.content.Context;
import com.devtodev.core.utils.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final String VERSION_STORAGE = "1";
    private static final String[] hexSymbols = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final int BITS_PER_HEX_DIGIT = 4;

    public static boolean isStorageExist(Context context, String name) {
        String localName = name + VERSION_STORAGE;
        File f2 = new File(context.getFilesDir().getAbsolutePath() + File.separator + localName);
        return f2.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStorage(Context context, Object storage, String name) {
        if (storage == null) {
            return false;
        }
        String localName = name + VERSION_STORAGE;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = context.openFileOutput(localName, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(storage);
            objectOutputStream.reset();
            boolean bl = true;
            return bl;
        }
        catch (IOException e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loadStorage(Context context, Class<T> storageClass, String name) {
        FileInputStream fis;
        String localName = name + VERSION_STORAGE;
        try {
            File f2 = new File(context.getFilesDir().getAbsolutePath() + File.separator + localName);
            if (!f2.exists()) {
                f2.createNewFile();
                return IOUtils.getNew(storageClass);
            }
            fis = context.openFileInput(localName);
        }
        catch (FileNotFoundException e2) {
            return IOUtils.getNew(storageClass);
        }
        catch (Exception e3) {
            return IOUtils.getNew(storageClass);
        }
        ObjectInputStream is = null;
        Object object = null;
        try {
            if (fis.available() > 0) {
                is = new ObjectInputStream(fis);
                object = is.readObject();
            }
        }
        catch (Exception e4) {
            Logger.d("Error loading file: " + localName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e5) {
                e5.printStackTrace();
            }
        }
        try {
            if (object == null) {
                return IOUtils.getNew(storageClass);
            }
            return storageClass.cast(object);
        }
        catch (ClassCastException e6) {
            return IOUtils.getNew(storageClass);
        }
    }

    private static <T> T getNew(Class<T> pClass) {
        Logger.d("Create new " + pClass.getName());
        try {
            return pClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(Context context, String fileName, String value) {
        FileOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = context.openFileOutput(fileName, 0);
            oos = new ObjectOutputStream(os);
            oos.writeObject(value);
        }
        catch (IOException e2) {
            Logger.d("Error saving file");
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String loadString(Context context, String fileName) {
        File file = context.getFileStreamPath(fileName);
        return IOUtils.loadString(file);
    }

    public static boolean deleteString(Context context, String fileName) {
        File file = context.getFileStreamPath(fileName);
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file) {
        FileInputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = new FileInputStream(file);
            ois = new ObjectInputStream(is);
            Object o = ois.readObject();
            if (o != null && o instanceof String) {
                String string = (String)o;
                return string;
            }
        }
        catch (Exception e2) {
            Logger.d("Error loading file: " + file.getName());
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return "";
    }

    public static boolean deleteStorage(Context context, String name) {
        String localName = name + VERSION_STORAGE;
        return context.deleteFile(localName);
    }

    private static int stringHexToInt(String substring) {
        return Integer.parseInt(substring.toUpperCase(), 16);
    }

    private static String toHexFromByte(byte b2) {
        byte leftSymbol = (byte)(b2 >>> 4 & 0xF);
        byte rightSymbol = (byte)(b2 & 0xF);
        return hexSymbols[leftSymbol] + hexSymbols[rightSymbol];
    }

    private static String toHexFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder hexBuffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            hexBuffer.append(IOUtils.toHexFromByte(aByte));
        }
        return hexBuffer.toString();
    }
}

