/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.devtodev.core.data.storages.SdkStorage;
import com.devtodev.core.utils.IOUtils;
import com.devtodev.core.utils.Logger;
import com.devtodev.push.DevToDevPushManager;
import com.devtodev.push.PushListener;
import com.devtodev.push.data.PushMessage;
import com.devtodev.push.data.metrics.PushOpen;
import com.devtodev.push.data.metrics.PushReceived;
import com.devtodev.push.data.metrics.TokenSend;
import com.devtodev.push.logic.PushStorage;
import com.devtodev.push.logic.notification.ActionButton;
import com.devtodev.push.logic.notification.ActionType;
import com.devtodev.push.utils.FirebaseOptionsLoader;
import com.devtodev.push.utils.MetricsSender;
import com.devtodev.push.utils.PushStorageUtils;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.unity3d.player.UnityPlayer;
import java.util.LinkedList;
import java.util.Map;

public class PushClient {
    public static final String MESSAGE_BUNDLE = "com.devtodev.android.MESSAGE_BUNDLE";
    public static final String BUTTON_ID_BUNDLE = "com.devtodev.android.BUTTON_ID";
    private Context context;
    private PushListener pushListener;
    private PushStorage pushStorage;
    private SdkStorage sdkStorage;
    private String deviceId;
    private LinkedList<PushMessage> savedMessage;
    private LinkedList<ActionButton> savedButton;

    PushClient(Context context) {
        try {
            this.context = context;
            this.savedMessage = new LinkedList();
            this.savedButton = new LinkedList();
            this.loadStorage();
            this.sdkStorage = new SdkStorage(context);
            this.sdkStorage.load();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean getNotificationsEnabled() {
        return this.sdkStorage.getNotificationsEnabled();
    }

    public void setNotificationsEnabled(boolean value) {
        this.sdkStorage.setNotificationEnabled(value);
        this.sdkStorage.save();
    }

    public void onPushReceived(Context context, PushMessage message) {
        this.context = context;
        if (this.pushListener != null) {
            this.pushListener.onPushNotificationsReceived(message.getData());
            message.receive();
        }
        this.sendPushReceived(message.getSystemId());
    }

    public void onPushClicked(Context context, PushMessage message, String buttonId) {
        this.context = context;
        boolean isInitialized = DevToDevPushManager.getInstance(context).isInitialized();
        this.loadStorage();
        if (message != null && !this.pushStorage.contains(message)) {
            this.pushStorage.pushMessage(message);
            this.pushStorage.pushActionId(buttonId);
        }
        if (isInitialized) {
            this.checkSavedData(context, buttonId, this.pushStorage.popMesage());
        }
        this.saveStorage();
    }

    void initialize(String config) {
        if (this.context != null) {
            this.obtainDeviceId(config);
        }
    }

    void setIntent(Context context, Intent pIntent) {
        this.context = context;
        this.checkIntent(pIntent);
    }

    void setPushListener(PushListener pushListener) {
        if (pushListener == null) {
            return;
        }
        this.pushListener = pushListener;
        if (this.deviceId != null && this.deviceId.length() > 0) {
            this.pushListener.onRegisteredForPushNotifications(this.deviceId);
            this.deviceId = null;
        }
        while (this.savedMessage.size() > 0) {
            PushMessage pushMessage = this.savedMessage.removeLast();
            ActionButton actionButton = this.savedButton.removeLast();
            this.pushListener.onPushNotificationsReceived(pushMessage.getData());
            if (pushMessage.isHidden()) continue;
            pushListener.onPushNotificationOpened(pushMessage, actionButton);
        }
    }

    private void checkIntent(Intent pIntent) {
        if (this.context == null) {
            this.context = UnityPlayer.currentActivity;
        }
        PushMessage pushMessage = (PushMessage)pIntent.getSerializableExtra(MESSAGE_BUNDLE);
        String buttonId = pIntent.getStringExtra(BUTTON_ID_BUNDLE);
        pIntent.removeExtra(MESSAGE_BUNDLE);
        pIntent.removeExtra(BUTTON_ID_BUNDLE);
        if (pushMessage != null && !this.pushStorage.contains(pushMessage)) {
            this.pushStorage.pushMessage(pushMessage);
            this.pushStorage.pushActionId(buttonId);
        }
        while (this.pushStorage.hasStoredNotifications()) {
            PushMessage notification = this.pushStorage.popMesage();
            String actionId = this.pushStorage.popActionId();
            this.checkSavedData(this.context, actionId, notification);
        }
    }

    private void checkSavedData(Context context, String buttonId, PushMessage pushMessage) {
        if (context == null) {
            return;
        }
        if (this.pushStorage == null) {
            this.pushStorage = IOUtils.loadStorage(context, PushStorage.class, PushStorage.NAME);
        }
        int _k = pushMessage.getSystemId();
        ActionButton clickedButton = this.getClickedButton(pushMessage, buttonId);
        if (!this.pushStorage.isPushIdExist(_k) || pushMessage.isApiSource()) {
            if (this.pushListener != null) {
                if (!pushMessage.isReceived()) {
                    Map<String, String> map = pushMessage.getData();
                    this.pushListener.onPushNotificationsReceived(map);
                }
                if (!pushMessage.isHidden()) {
                    this.pushListener.onPushNotificationOpened(pushMessage, clickedButton);
                }
            } else {
                this.savedMessage.addFirst(pushMessage);
                this.savedButton.addFirst(clickedButton);
            }
            if (!pushMessage.isHidden()) {
                if (clickedButton != null) {
                    this.executeAction(clickedButton.getActionType(), clickedButton.getActionString());
                } else {
                    this.executeAction(pushMessage.getActionType(), pushMessage.getActionString());
                }
            }
            this.sendPushOpen(_k, buttonId);
            this.pushStorage.addPushId(_k);
        }
        IOUtils.saveStorage(context, this.pushStorage, PushStorage.NAME);
    }

    private void sendPushReceived(int pushId) {
        Logger.d("Save metric PushReceived with id " + pushId + " for future execution.");
        MetricsSender.saveMetricToStorage(this.context, new PushReceived(pushId));
    }

    private void sendPushOpen(int pushId, String buttonId) {
        Logger.d("Save metric PushOpen with id " + pushId + " for future execution.");
        MetricsSender.saveMetricToStorage(this.context, new PushOpen(pushId, buttonId));
    }

    private void obtainDeviceId(String config) {
        this.deviceId = PushStorageUtils.getRegistrationId(this.context);
        if (this.deviceId.isEmpty()) {
            this.registerInBackground(config);
        } else {
            MetricsSender.saveMetricToStorage(this.context, new TokenSend(this.deviceId));
        }
    }

    private void registerInBackground(String senderId) {
        Logger.d("registerInBackground: " + senderId);
        if (senderId == null) {
            senderId = this.tryGetGCMSenderId();
        }
        try {
            this.addOnSuccessTokenListener();
        }
        catch (Exception e2) {
            FirebaseOptions options = new FirebaseOptionsLoader(this.context).load(senderId);
            if (options == null) {
                String error = "SenderId don't found. Push notification can't work.";
                Logger.e("SenderId don't found. Push notification can't work.");
                if (this.pushListener != null) {
                    this.pushListener.onFailedToRegisteredForPushNotifications("SenderId don't found. Push notification can't work.");
                }
                return;
            }
            FirebaseApp.initializeApp((Context)this.context, (FirebaseOptions)options);
        }
    }

    private void addOnSuccessTokenListener() {
        Logger.d("addOnSuccessTokenListener");
        FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

            public void onSuccess(InstanceIdResult instanceIdResult) {
                Log.e((String)"DevToDev", (String)("OnSuccessListener: " + instanceIdResult.getToken()));
                String deviceToken = instanceIdResult.getToken();
                PushClient.this.onTokenReceived(deviceToken);
            }
        });
        FirebaseInstanceId.getInstance().getInstanceId().addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                Log.e((String)"DevToDev", (String)("OnFailureListener: " + e2.getLocalizedMessage()));
                e2.printStackTrace();
            }
        });
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(@NonNull Task<InstanceIdResult> task) {
                Log.e((String)"DevToDev", (String)("OnCompleteListener: " + task.toString()));
            }
        });
        FirebaseInstanceId.getInstance().getInstanceId().addOnCanceledListener(new OnCanceledListener(){

            public void onCanceled() {
                Log.e((String)"DevToDev", (String)"OnCanceledListener: ");
            }
        });
    }

    private void onTokenReceived(String token) {
        if (token != null) {
            if (this.pushListener != null) {
                this.pushListener.onRegisteredForPushNotifications(token);
            }
            PushStorageUtils.storeRegistrationId(this.context, token);
            MetricsSender.saveMetricToStorage(this.context, new TokenSend(token));
        }
    }

    private String tryGetGCMSenderId() {
        try {
            ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString("PUSH_SENDER_ID");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private void saveStorage() {
        IOUtils.saveStorage(this.context, this.pushStorage, PushStorage.NAME);
    }

    private void loadStorage() {
        this.pushStorage = IOUtils.loadStorage(this.context, PushStorage.class, PushStorage.NAME);
    }

    private ActionButton getClickedButton(PushMessage pushMessage, String buttonId) {
        if (buttonId == null) {
            return null;
        }
        for (ActionButton action : pushMessage.getActions()) {
            if (!action.getId().equals(buttonId)) continue;
            return action;
        }
        return null;
    }

    private void executeAction(ActionType actionType, String actionString) {
        try {
            Logger.d("actionType: " + (Object)((Object)actionType) + " actionString: " + actionString);
            if (actionType == null) {
                return;
            }
            switch (actionType) {
                case URL: {
                    this.openUrl(actionString);
                    break;
                }
                case SHARE: {
                    this.openShare(actionString);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void openUrl(String url) {
        if (url != null) {
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            browserIntent.setFlags(0x30000000);
            this.context.startActivity(browserIntent);
        }
    }

    private void openShare(String text) {
        if (text != null) {
            Intent sendIntent = new Intent();
            sendIntent.setFlags(0x30000000);
            sendIntent.setAction("android.intent.action.SEND");
            sendIntent.putExtra("android.intent.extra.TEXT", text);
            sendIntent.setType("text/plain");
            this.context.startActivity(sendIntent);
        }
    }
}

