/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.data;

import android.content.Context;
import android.content.res.Resources;
import android.media.RingtoneManager;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.devtodev.push.logic.notification.ActionButton;
import com.devtodev.push.logic.notification.ActionType;
import com.devtodev.push.utils.ResourceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PushMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_ID = "_k";
    private static final String MESSAGE_TITLE = "title";
    private static final String MESSAGE_BODY = "alert";
    private static final String MESSAGE_ICON = "icon";
    private static final String MESSAGE_LARGE_ICON = "_largeIcon";
    private static final String MESSAGE_SOUND = "sound";
    private static final String MESSAGE_TAG = "tag";
    private static final String MESSAGE_COLOR = "color";
    private static final String MESSAGE_PRIORITY = "priority";
    private static final String MESSAGE_ACTIONS = "_interactive";
    private static final String MESSAGE_LED = "_led";
    private static final String MESSAGE_ON_MS = "_onMs";
    private static final String MESSAGE_OFF_MS = "_offMs";
    private static final String MESSAGE_BANNER = "_banner";
    private static final String MESSAGE_HIDDEN = "_h";
    private static final String MESSAGE_COLLAPSE = "collapse_key";
    private static final String MESSAGE_API = "_api";
    private static final String MESSAGE_VIBRATION = "_vibration";
    private static final String MESSAGE_CHANNEL = "_channel_id";
    private static final String MESSAGE_BADGES = "badge";
    private static final String MESSAGE_BADGE_ICON_TYPE = "_badge_icon_type";
    private static final HashSet<String> excludeKeys = new HashSet<String>(Arrays.asList("_k", "title", "alert", "icon", "_largeIcon", "sound", "tag", "color", "priority", "_interactive", "_led", "_onMs", "_offMs", "_banner", "_h", "collapse_key", "_vibration", "_api", "_channel_id", "badge", "_badge_icon_type", ActionType.URL.getKey(), ActionType.SHARE.getKey(), ActionType.DEEPLINK.getKey(), "google.sent_time", "google.message_id", "_smallIcon"));
    private Map<String, String> data;
    private Map<String, String> customPayload;
    private ActionType actionType;
    private transient Uri sound;
    private boolean isReceived = false;
    private boolean isOpened = false;

    public PushMessage(@NonNull Map<String, String> data) {
        this.data = data;
    }

    public int getBadgeIconType() {
        if (this.data.get(MESSAGE_BADGE_ICON_TYPE) != null) {
            return Integer.parseInt(this.data.get(MESSAGE_BADGE_ICON_TYPE));
        }
        return 0;
    }

    public int getSystemId() {
        try {
            return Integer.parseInt(this.data.get(MESSAGE_ID));
        }
        catch (Exception e2) {
            return 0;
        }
    }

    @Nullable
    public String getTitle(Context context) {
        String title = this.data.get(MESSAGE_TITLE);
        if (title == null) {
            try {
                Resources appR = context.getResources();
                title = appR.getText(appR.getIdentifier("app_name", "string", context.getPackageName())).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return title;
    }

    @Nullable
    public String getBody() {
        return this.data.get(MESSAGE_BODY);
    }

    @Nullable
    public String getLargeIcon() {
        return this.data.get(MESSAGE_LARGE_ICON);
    }

    @Nullable
    public Uri getSound(Context context) {
        if (this.sound != null) {
            return this.sound;
        }
        String soundName = this.data.get(MESSAGE_SOUND);
        if (soundName == null) {
            return null;
        }
        int resId = ResourceUtils.getApplicationResourceId(context, "raw", soundName);
        this.sound = resId == 0 || soundName.equalsIgnoreCase("default") ? RingtoneManager.getDefaultUri((int)2) : Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + resId));
        return this.sound;
    }

    @Nullable
    public String getTag() {
        return this.data.get(MESSAGE_TAG);
    }

    @Nullable
    public String getColor() {
        return this.data.get(MESSAGE_COLOR);
    }

    @Nullable
    public String getBigPicture() {
        return this.data.get(MESSAGE_BANNER);
    }

    @Nullable
    public ActionType getActionType() {
        if (this.actionType != null) {
            return this.actionType;
        }
        if (this.data.get(ActionType.URL.getKey()) != null) {
            this.actionType = ActionType.URL;
        } else if (this.data.get(ActionType.SHARE.getKey()) != null) {
            this.actionType = ActionType.SHARE;
        } else if (this.data.get(ActionType.DEEPLINK.getKey()) != null) {
            this.actionType = ActionType.DEEPLINK;
        }
        return this.actionType;
    }

    @Nullable
    public String getActionString() {
        if (this.actionType == null) {
            return null;
        }
        return this.data.get(this.actionType.getKey());
    }

    public int getIcon(Context context, String userIcon) {
        String iconString = this.data.get(MESSAGE_ICON);
        int iconId = iconString != null ? ResourceUtils.getApplicationResourceId(context, "drawable", iconString) : ResourceUtils.getApplicationResourceId(context, "drawable", userIcon);
        if (iconId == 0) {
            iconId = ResourceUtils.getApplicationResourceId(context, "drawable", null);
        }
        return iconId;
    }

    public int getLed() {
        try {
            String led = this.data.get(MESSAGE_LED);
            if (led != null) {
                return 0xFF000000 | Integer.parseInt(led, 16);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return 0;
    }

    public int getLedOnMs() {
        try {
            return Integer.parseInt(this.data.get(MESSAGE_ON_MS));
        }
        catch (Exception e2) {
            return 1000;
        }
    }

    public int getLedOffMs() {
        try {
            return Integer.parseInt(this.data.get(MESSAGE_OFF_MS));
        }
        catch (Exception e2) {
            return 1000;
        }
    }

    public String getPriority() {
        return this.data.get(MESSAGE_PRIORITY);
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.data.get(MESSAGE_HIDDEN));
    }

    public Map<String, String> getData() {
        if (this.customPayload != null && this.customPayload.size() > 0) {
            return this.customPayload;
        }
        this.customPayload = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            if (excludeKeys.contains(entry.getKey())) continue;
            this.customPayload.put(entry.getKey(), entry.getValue());
        }
        return this.customPayload;
    }

    public List<ActionButton> getActions() {
        String categoryPayload = this.data.get(MESSAGE_ACTIONS);
        ArrayList<ActionButton> actions = new ArrayList<ActionButton>();
        if (categoryPayload != null) {
            try {
                JSONObject category = new JSONObject(categoryPayload);
                JSONArray actionsArray = category.optJSONArray("buttons");
                if (actionsArray != null) {
                    for (int index = 0; index < actionsArray.length(); ++index) {
                        actions.add(new ActionButton(actionsArray.optJSONObject(index)));
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return actions;
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean isApiSource() {
        String api = this.data.get(MESSAGE_API);
        return api != null && api.equals("true");
    }

    public boolean isVibrationEnabled() {
        if (this.data.get(MESSAGE_VIBRATION) != null) {
            return Boolean.valueOf(this.data.get(MESSAGE_VIBRATION));
        }
        return true;
    }

    public String getChannel() {
        return this.data.get(MESSAGE_CHANNEL);
    }

    public int getBadgeCount() {
        if (this.data.get(MESSAGE_BADGES) != null) {
            return Integer.valueOf(this.data.get(MESSAGE_BADGES));
        }
        return -1;
    }

    @Nullable
    public JSONObject ToJSON() {
        try {
            JSONObject jso = new JSONObject();
            jso.put("actionType", (this.getActionType() == null ? -1 : this.getActionType().ordinal()) + 1);
            Map<String, String> userData = this.getData();
            for (Map.Entry<String, String> ent : userData.entrySet()) {
                jso.put(ent.getKey(), (Object)ent.getValue());
            }
            jso.put("actionString", (Object)this.getActionString());
            return jso;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void receive() {
        this.isReceived = true;
    }

    public void open() {
        this.isOpened = true;
    }

    public boolean isReceived() {
        return this.isReceived;
    }

    public boolean isOpened() {
        return this.isOpened;
    }
}

