/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.logic.notification;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import com.devtodev.core.utils.IOUtils;
import com.devtodev.push.data.PushMessage;
import com.devtodev.push.logic.PushStorage;
import com.devtodev.push.logic.notification.ActionButton;
import com.devtodev.push.utils.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Random;

public class NotificationConstructor {
    private Context context;
    private PushMessage message;
    private Notification.Builder builder;
    private PushStorage pushStorage;

    public NotificationConstructor(Context context) {
        this.context = context;
    }

    public void fillNotification(Notification.Builder builder, PushMessage message) {
        this.message = message;
        this.builder = builder;
        this.pushStorage = IOUtils.loadStorage(this.context, PushStorage.class, PushStorage.NAME);
        builder.setAutoCancel(true);
        this.passSmallIcon();
        this.passLargeIcon();
        this.passAutoCancel(true);
        this.passContentTitle();
        this.passContentText();
        this.passSound();
        this.passStyle();
        this.passLed();
        this.passButtons();
        this.passPriority();
        this.passColor();
        this.passVibration();
        this.passBadges();
    }

    private void passBadges() {
        int count = this.message.getBadgeCount();
        if (count >= 0) {
            this.builder.setNumber(count);
            if (Build.VERSION.SDK_INT >= 26) {
                this.builder.setBadgeIconType(this.message.getBadgeIconType());
            }
        }
    }

    private void passVibration() {
        if (this.message.isVibrationEnabled()) {
            this.builder.setVibrate(new long[]{0L, 100L, 0L, 100L});
        } else {
            this.builder.setVibrate(new long[]{0L});
        }
    }

    private void passColor() {
        String color;
        if (Build.VERSION.SDK_INT >= 21 && (color = this.message.getColor()) != null) {
            try {
                int argb = 0xFF000000 | Integer.parseInt(color, 16);
                this.builder.setColor(argb);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void passPriority() {
        if (Build.VERSION.SDK_INT >= 16) {
            String priority = this.message.getPriority();
            if (priority != null && priority.equalsIgnoreCase("high")) {
                this.builder.setPriority(1);
            } else {
                this.builder.setPriority(0);
            }
        }
    }

    private void passButtons() {
        if (Build.VERSION.SDK_INT >= 16) {
            List<ActionButton> buttons = this.message.getActions();
            int index = 0;
            int startNumber = new Random().nextInt();
            for (ActionButton button : buttons) {
                Intent intent = new Intent();
                intent.setPackage(this.context.getPackageName());
                intent.setAction("com.devtodev.android.push.CLICKED");
                intent.putExtra("com.devtodev.android.MESSAGE_BUNDLE", (Serializable)this.message);
                intent.putExtra("com.devtodev.android.BUTTON_ID", button.getId());
                PendingIntent contentIntent = PendingIntent.getBroadcast((Context)this.context, (int)(startNumber + index), (Intent)intent, (int)0x48000000);
                int icon = ResourceUtils.getApplicationResourceId(this.context, "drawable", button.getIcon());
                String text = button.getText();
                if (Build.VERSION.SDK_INT < 23) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.builder.addAction(icon, (CharSequence)text, contentIntent);
                    }
                } else {
                    Notification.Action action = new Notification.Action.Builder(icon, (CharSequence)text, contentIntent).build();
                    this.builder.addAction(action);
                }
                ++index;
            }
        }
    }

    private void passLed() {
        int argb = this.message.getLed();
        if (argb != 0) {
            this.builder.setLights(argb, this.message.getLedOnMs(), this.message.getLedOffMs());
        }
    }

    private void passSmallIcon() {
        this.builder.setSmallIcon(this.message.getIcon(this.context, this.pushStorage.getSmallIcon()));
    }

    private void passLargeIcon() {
        String largeIconString = this.message.getLargeIcon();
        if (largeIconString == null) {
            int id;
            String iconId = this.pushStorage.getLargeIcon();
            if (iconId != null && !iconId.equals("") && (id = ResourceUtils.getApplicationResourceId(this.context, "drawable", iconId)) != 0) {
                this.builder.setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)id));
            }
            return;
        }
        Bitmap iconBitmap = largeIconString.contains("http://") || largeIconString.contains("https://") ? this.loadBitmap(largeIconString) : this.loadIconFromResources(largeIconString);
        if (iconBitmap == null) {
            iconBitmap = this.loadIconFromResources(null);
        }
        this.builder.setLargeIcon(iconBitmap);
    }

    private void passAutoCancel(boolean autoCancel) {
        this.builder.setAutoCancel(autoCancel);
    }

    private void passSound() {
        Uri sound = this.message.getSound(this.context);
        if (sound != null) {
            this.builder.setSound(sound);
        }
    }

    private void passContentText() {
        this.builder.setContentText((CharSequence)this.message.getBody());
    }

    private void passContentTitle() {
        this.builder.setContentTitle((CharSequence)this.message.getTitle(this.context));
    }

    private void passStyle() {
        if (Build.VERSION.SDK_INT >= 16) {
            String bannerPath = this.message.getBigPicture();
            if (bannerPath != null) {
                Bitmap banner = this.loadBitmap(bannerPath);
                this.builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(banner).setSummaryText((CharSequence)this.message.getBody()));
            } else {
                this.builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)this.message.getBody()));
            }
        }
    }

    private Bitmap loadIconFromResources(String drawableName) {
        int iconId = drawableName != null ? ResourceUtils.getApplicationResourceId(this.context, "drawable", drawableName) : ResourceUtils.getApplicationResourceId(this.context, "drawable", null);
        return BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)iconId);
    }

    private Bitmap loadBitmap(String bitmapPath) {
        try {
            URL url = new URL(bitmapPath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            return BitmapFactory.decodeStream((InputStream)input);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

