/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.devtodev.core.utils.Logger;
import com.devtodev.push.DevToDevPushManager;
import com.devtodev.push.data.PushMessage;
import com.devtodev.push.logic.notification.NotificationConstructor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class NotificationMaker
extends AsyncTask<Object, Void, Notification> {
    private static final String DEFAULT_CHANNEL = "_devtodev";

    protected Notification doInBackground(Object ... params) {
        Context context = (Context)params[0];
        PushMessage message = new PushMessage(this.getCurrentParameters(params[1]));
        int _k = message.getSystemId();
        DevToDevPushManager.getInstance(context).onPushReceived(context, message);
        if (message.isHidden()) {
            DevToDevPushManager.getInstance(context).onPushClicked(context, message, null);
        } else {
            Intent intent = this.obtainIntent(context);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (intent != null) {
                intent.putExtra("com.devtodev.android.MESSAGE_BUNDLE", (Serializable)message);
                String channel = message.getChannel();
                if (Build.VERSION.SDK_INT >= 26 && notificationManager != null && notificationManager.getNotificationChannel(DEFAULT_CHANNEL) == null) {
                    int resourceId = context.getResources().getIdentifier("default_notification_channel_name", "strings", context.getPackageName());
                    String channelName = "General notifications";
                    if (resourceId != 0) {
                        channelName = context.getString(resourceId);
                    }
                    NotificationChannel notificationChannel = new NotificationChannel(DEFAULT_CHANNEL, (CharSequence)channelName, 3);
                    notificationManager.createNotificationChannel(notificationChannel);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    Notification.Builder builder = this.getNotificationBuilder(context, notificationManager, channel);
                    NotificationConstructor constructor = new NotificationConstructor(context);
                    constructor.fillNotification(builder, message);
                    builder.setContentIntent(this.obtainPendingIntent(_k, context, intent));
                    Notification notification = builder.build();
                    notification.flags |= 0x10;
                    try {
                        if (notificationManager != null && DevToDevPushManager.getInstance().getNotificationsEnabled()) {
                            notificationManager.notify(_k, notification);
                        } else {
                            Logger.d("Push notification received but turned off in native code.");
                        }
                    }
                    catch (SecurityException e2) {
                        Logger.e("Please add VIBRATE permission into your AndroidManifest.xml\nhttps://android.googlesource.com/platform/frameworks/base/+/cc2e849");
                    }
                }
            }
        }
        return null;
    }

    @NonNull
    private Notification.Builder getNotificationBuilder(Context context, NotificationManager notificationManager, String channel) {
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? (channel != null && notificationManager != null && notificationManager.getNotificationChannel(channel) != null ? new Notification.Builder(context, channel) : new Notification.Builder(context, DEFAULT_CHANNEL)) : new Notification.Builder(context);
        return builder;
    }

    private PendingIntent obtainPendingIntent(int pushId, Context context, Intent intent) {
        return PendingIntent.getBroadcast((Context)context, (int)pushId, (Intent)intent, (int)0x8000000);
    }

    private Intent obtainIntent(Context context) {
        Intent intent = new Intent();
        intent.setPackage(context.getPackageName());
        intent.setAction("com.devtodev.android.push.CLICKED");
        return intent;
    }

    private HashMap<String, String> getCurrentParameters(Object param) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (param instanceof Bundle) {
            Bundle bundle = (Bundle)param;
            for (String key : bundle.keySet()) {
                parameters.put(key, String.valueOf(bundle.get(key)));
            }
        } else {
            parameters = new HashMap((Map)param);
        }
        return parameters;
    }
}

