/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

public class PushStorageUtils {
    public static final String TAG = PushStorageUtils.class.getSimpleName();
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_REG_ID = "registration_id";

    public static void storeRegistrationId(Context context, String regId) {
        SharedPreferences prefs = PushStorageUtils.getGCMPreferences(context);
        int appVersion = PushStorageUtils.getAppVersion(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId.trim());
        editor.putInt(PROPERTY_APP_VERSION, appVersion);
        editor.apply();
    }

    public static String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = PushStorageUtils.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (registrationId.isEmpty()) {
            return "";
        }
        int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = PushStorageUtils.getAppVersion(context))) {
            return "";
        }
        return registrationId;
    }

    private static SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(context.getPackageName(), 0);
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e2) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e2));
        }
    }
}

