/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.unity.udp.sdk.AppInfo;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.LicenseCheckCallback;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.ResultCode;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProvider;
import com.unity.udp.sdk.provider.ChannelProviderService;
import com.unity3d.player.UnityPlayer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelService {
    private static final String VALUE_PREFIX = "string:";
    private static ChannelProviderService channelProviderService = null;
    private static ChannelHandler channelHandler = null;
    private static String storeName;

    public static void init(Activity activity, AppInfo appInfo, final InitCallback initCallback) {
        String serviceName;
        if (appInfo == null) {
            Logger.logError((String)"AppInfo cannot be null");
            return;
        }
        if (initCallback == null) {
            Logger.logError((String)"InitCallback cannot be null");
            return;
        }
        try {
            serviceName = Utils.getAndroidMetadata((Context)activity, "CHANNEL_NAME");
            channelProviderService = ChannelService.selectProvider(serviceName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.logError((String)"Cannot get store name for UDP to initialize");
            return;
        }
        if (channelProviderService == null) {
            Logger.logError((String)"Cannot choose provider service");
            return;
        }
        if (channelProviderService.needRsaPublicKey()) {
            try {
                String rsaPublicKey = Utils.getAndroidMetadata((Context)activity, "publicKey");
                if (Utils.isEmptyString(rsaPublicKey)) {
                    Logger.logError((String)("Cannot get RSA public key for " + serviceName + " to initialize"));
                    return;
                }
                appInfo.setRSAPublicKey(rsaPublicKey);
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.logError((String)("Cannot get RSA public key for " + serviceName + " to initialize"));
                return;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (channelProviderService.otherInfo() != null && channelProviderService.otherInfo().size() != 0) {
            List<String> otherInfo = channelProviderService.otherInfo();
            for (String name : otherInfo) {
                try {
                    String value = Utils.getAndroidMetadata((Context)activity, name).trim();
                    map.put(name, value);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Logger.logError((String)String.format("Cannot get %s for %s to initialize", name, serviceName));
                    return;
                }
            }
        }
        Logger.setStore((String)channelProviderService.getProviderName());
        channelHandler = new ChannelHandler(appInfo, channelProviderService, map);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                channelHandler.startInit(initCallback);
            }
        });
    }

    public static void licenseCheck(final LicenseCheckCallback callback) {
        Activity activity = UnityPlayer.currentActivity;
        if (channelProviderService == null) {
            try {
                String serviceName = Utils.getAndroidMetadata((Context)activity, "CHANNEL_NAME");
                channelProviderService = ChannelService.selectProvider(serviceName);
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.logError((String)"Cannot get store name for UDP to initialize");
                callback.applicationError(6, "Cannot get store name for UDP to initialize");
                return;
            }
        }
        if (channelProviderService == null) {
            Logger.logError((String)"Cannot choose provider service");
            callback.applicationError(6, "Cannot choose provider service");
            return;
        }
        Handler mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                int action = msg.what;
                Map map = (Map)msg.obj;
                String message = (String)map.get("MESSAGE");
                int code = (Integer)map.get("RESULT");
                switch (action) {
                    case 9000: {
                        callback.allow(code, message);
                        break;
                    }
                    case 9001: {
                        callback.dontAllow(code, message);
                        break;
                    }
                    case 9002: {
                        callback.applicationError(code, message);
                    }
                }
                return false;
            }
        });
        try {
            switch (channelProviderService.getProviderName()) {
                case "CLOUDMOOLAH": {
                    channelProviderService.licenseCheck(activity, mHandler, callback);
                    break;
                }
                default: {
                    callback.allow(4, "store doesn't support pay to download");
                    break;
                }
            }
        }
        catch (Exception ex) {
            Logger.logError((String)("license check service not implemented by store sdk " + ex.getMessage()));
            callback.allow(4, "store doesn't support pay to download");
        }
    }

    public static void purchase(final PurchaseInfo purchaseInfo, final PurchaseCallback purchaseCallback) {
        String check = ChannelService.handleEnvCheck(purchaseCallback, "PurchaseCallback", (Object)purchaseInfo, "PurchaseInfo");
        if (check != null) {
            Logger.logError((String)check);
            purchaseCallback.onPurchaseFinished(ResultCode.SDK_PURCHASE_FAILED, check, purchaseInfo.toJsonString());
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                channelHandler.startPurchase(purchaseInfo, purchaseCallback);
            }
        });
    }

    public static void consumePurchase(PurchaseInfo purchaseInfo, PurchaseCallback purchaseCallback) {
        String check = ChannelService.handleEnvCheck(purchaseCallback, "PurchaseCallback", (Object)purchaseInfo, "PurchaseInfo");
        if (check != null) {
            Logger.logError((String)check);
            purchaseCallback.onConsumeFinished(ResultCode.SDK_CONSUME_PURCHASE_FAILED, check, purchaseInfo.toJsonString());
            return;
        }
        channelHandler.startConsume(purchaseInfo, purchaseCallback);
    }

    public static void consumePurchases(List<PurchaseInfo> purchaseInfos, PurchaseCallback purchaseCallback) {
        String check = ChannelService.handleEnvCheck(purchaseInfos, "PurchaseInfos", purchaseCallback, "PurchaseCallback");
        if (check != null) {
            Logger.logError((String)check);
            return;
        }
        channelHandler.startConsume(purchaseInfos, purchaseCallback);
    }

    public static void queryInventory(String[] productIds, PurchaseCallback purchaseCallback) {
        String check = ChannelService.handleEnvCheck(purchaseCallback, "PurchaseCallback", null, null);
        if (check != null) {
            Logger.logError((String)check);
            JSONObject object = new JSONObject();
            try {
                object.put("productIds", (Object)Arrays.toString(productIds));
            }
            catch (JSONException ex) {
                Logger.logError((String)("Assemble product ids JSON error: " + ex.getMessage()));
            }
            purchaseCallback.onQueryInventory(ResultCode.SDK_QUERY_INVENTORY_FAILED, check, object.toString());
            return;
        }
        channelHandler.startQueryInventory(productIds, purchaseCallback);
    }

    public static void enableDebugLogging(boolean isEnabled, String tag) {
        ChannelService.handleEnvCheck(channelProviderService, "ChannelProviderService", null, null);
        Logger.enableDebugLog((boolean)isEnabled);
        if (Utils.isEmptyString(tag)) {
            channelProviderService.enableDebugLogging(isEnabled);
        } else {
            channelProviderService.enableDebugLogging(isEnabled, tag);
        }
    }

    public static String getStoreName() {
        if (storeName == null) {
            try {
                String serviceName;
                storeName = serviceName = Utils.getAndroidMetadata((Context)UnityPlayer.currentActivity, "CHANNEL_NAME");
                return ChannelProvider.getChannelProviderService(storeName).getProviderDisplayName();
            }
            catch (Exception e) {
                return "UDP";
            }
        }
        return ChannelProvider.getChannelProviderService(storeName).getProviderDisplayName();
    }

    private static ChannelProviderService selectProvider(String channelName) {
        if (Utils.isEmptyString(channelName)) {
            Logger.logError((String)"Cannot select provider");
        }
        return ChannelProvider.getChannelProviderService(channelName);
    }

    private static String envCheck(Object object1, String object1Name, Object object2, String object2Name) {
        if (channelHandler == null || !channelHandler.hasInitSuccess()) {
            return "Please initialize first";
        }
        if (object1 == null && object1Name != null) {
            return object1Name + " cannot be null";
        }
        if (object2 == null && object2Name != null) {
            return object2Name + " cannot be null";
        }
        if (channelProviderService == null) {
            return "Channel provider cannot be null";
        }
        return null;
    }

    private static String handleEnvCheck(Object object1, String object1Name, Object object2, String object2Name) {
        String check = ChannelService.envCheck(object1, object1Name, object2, object2Name);
        if (check != null) {
            String serviceName;
            try {
                serviceName = Utils.getAndroidMetadata((Context)UnityPlayer.currentActivity, "CHANNEL_NAME");
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.logError((String)"Cannot get store name for UDP");
                return "Cannot get store name";
            }
            switch (serviceName = serviceName.toUpperCase()) {
                case "APTOIDE": {
                    ChannelService.safetyChannelProviderService(serviceName).handlePremiseValidationError(UnityPlayer.currentActivity, 0);
                    break;
                }
            }
        }
        return check;
    }

    private static ChannelProviderService safetyChannelProviderService(String channelName) {
        if (channelProviderService == null) {
            channelProviderService = ChannelService.selectProvider(channelName);
        }
        return channelProviderService;
    }
}

