/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import com.unity.udp.sdk.ProductInfo;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.rest.BaseModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InventoryInfo {
    Map<String, ProductInfo> productMap = new HashMap<String, ProductInfo>();
    Map<String, PurchaseInfo> purchaseMap = new HashMap<String, PurchaseInfo>();

    public ProductInfo getProductInfo(String productId) {
        return this.productMap.get(productId);
    }

    public PurchaseInfo getPurchaseInfo(String productId) {
        return this.purchaseMap.get(productId);
    }

    public boolean hasPurchase(String productId) {
        return this.purchaseMap.containsKey(productId);
    }

    public boolean hasProduct(String productId) {
        return this.productMap.containsKey(productId);
    }

    public void addProductInfo(ProductInfo productInfo) {
        this.productMap.put(productInfo.getProductId(), productInfo);
    }

    public void addPurchaseInfo(PurchaseInfo purchaseInfo) {
        this.purchaseMap.put(purchaseInfo.getProductId(), purchaseInfo);
    }

    public Map<String, ProductInfo> getProductMap() {
        return Collections.unmodifiableMap(this.productMap);
    }

    public Map<String, PurchaseInfo> getPurchaseMap() {
        return Collections.unmodifiableMap(this.purchaseMap);
    }

    public List<ProductInfo> getProductInfoList() {
        LinkedList<ProductInfo> list = new LinkedList<ProductInfo>();
        for (Map.Entry<String, ProductInfo> entry : this.productMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public List<PurchaseInfo> getPurchaseInfoList() {
        LinkedList<PurchaseInfo> list = new LinkedList<PurchaseInfo>();
        for (Map.Entry<String, PurchaseInfo> entry : this.purchaseMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray purchaseJsonArray = new JSONArray();
        JSONArray productJsonArray = new JSONArray();
        try {
            for (Map.Entry<String, ProductInfo> entry : this.productMap.entrySet()) {
                ProductInfo productInfo = entry.getValue();
                productJsonArray.put((Object)productInfo.toJsonObject());
            }
            for (Map.Entry<String, BaseModel> entry : this.purchaseMap.entrySet()) {
                PurchaseInfo purchaseInfo = (PurchaseInfo)entry.getValue();
                purchaseJsonArray.put((Object)purchaseInfo.toJsonObject());
            }
            jsonObject.put("purchases", (Object)purchaseJsonArray);
            jsonObject.put("products", (Object)productJsonArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}

