/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.unity.udp.sdk.AppInfo;
import com.unity.udp.sdk.ProductInfo;
import com.unity.udp.sdk.common.ItemType;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProvider;
import com.unity.udp.sdk.provider.ChannelProviderService;
import com.unity.udp.sdk.rest.GetAllProductsResponse;
import com.unity.udp.sdk.rest.Item;
import com.unity.udp.sdk.rest.PostTokenRequest;
import com.unity.udp.sdk.rest.PostTokenResponse;
import com.unity.udp.sdk.rest.UnityChannelRestClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Catalog {
    private static final String HTC_PRICESETS = "HTC_PurchaseFee";
    private static final String PRICE_MAP = "priceMap";
    private static final String DEFAULT = "DEFAULT";
    private static final String CURRENCY = "currency";
    private static final String PRICE = "price";
    private static final String HTC_COIN = "VC";
    private long updatedTime;
    private long tokenUpdatedTime;
    private HashMap<String, ProductInfo> products;
    private List<ProductInfo> productList;
    private String store;
    private Context context;
    private AppInfo appInfo;
    private String cachedAccessToken;
    private ExecutorService executor = Executors.newFixedThreadPool(3);

    public Catalog(String store, Context context, AppInfo appInfo) {
        this.products = new HashMap();
        this.store = store;
        this.context = context;
        this.appInfo = appInfo;
    }

    private void put(String productId, ProductInfo product) {
        this.products.put(productId, product);
        this.productList.add(product);
    }

    public ProductInfo get(String productId) {
        Future<?> future = this.executor.submit(new CatalogUpdater());
        try {
            future.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return this.products.get(productId);
        }
        return this.products.get(productId);
    }

    public Future update() {
        return this.executor.submit(new CatalogUpdater());
    }

    public List<ProductInfo> getProductList() {
        Future<?> future = this.executor.submit(new CatalogUpdater());
        try {
            future.get();
        }
        catch (InterruptedException e) {
            return this.productList;
        }
        catch (ExecutionException e) {
            return this.productList;
        }
        return this.productList;
    }

    public void remove(String productId) {
        if (this.products.containsKey(productId)) {
            this.products.remove(productId);
        }
    }

    private void parsingPrices(ProductInfo productInfo, String priceSetsJson) {
        ChannelProviderService providerService = ChannelProvider.getChannelProviderService(this.store);
        switch (providerService.getProviderName()) {
            case "HTC": {
                try {
                    JSONObject priceSets = new JSONObject(priceSetsJson);
                    JSONObject htcPriceSets = priceSets.getJSONObject(HTC_PRICESETS);
                    JSONObject htcPriceMap = htcPriceSets.getJSONObject(PRICE_MAP);
                    JSONArray htcPrices = htcPriceMap.getJSONArray(DEFAULT);
                    for (int i = 0; i < htcPrices.length(); ++i) {
                        JSONObject priceJson = htcPrices.getJSONObject(i);
                        if (!priceJson.optString(CURRENCY).equalsIgnoreCase(HTC_COIN)) continue;
                        productInfo.setCurrency(HTC_COIN);
                        productInfo.setPrice(priceJson.optString(PRICE));
                    }
                    break;
                }
                catch (JSONException e) {
                    Logger.logError((String)"Parsing catalog price failed");
                    break;
                }
            }
            case "XIAOMI": {
                break;
            }
            case "MIDAS": {
                break;
            }
            default: {
                return;
            }
        }
    }

    class CatalogUpdater
    implements Runnable {
        CatalogUpdater() {
        }

        @Override
        public void run() {
            boolean isConnected;
            ConnectivityManager cm = (ConnectivityManager)Catalog.this.context.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean bl = isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            if (!isConnected) {
                return;
            }
            if (System.currentTimeMillis() / 1000L - Catalog.this.updatedTime < 600L) {
                return;
            }
            if (System.currentTimeMillis() / 1000L - Catalog.this.tokenUpdatedTime > 1800L || Catalog.this.cachedAccessToken == null) {
                try {
                    Catalog.this.cachedAccessToken = this.getAccessToken().get();
                    Catalog.this.tokenUpdatedTime = System.currentTimeMillis() / 1000L;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (ExecutionException e) {
                    return;
                }
            }
            GetAllProductsResponse productsResponse = null;
            try {
                productsResponse = this.fetchProducts().get();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (ExecutionException e) {
                return;
            }
            Catalog.this.updatedTime = System.currentTimeMillis() / 1000L;
            Catalog.this.productList = new ArrayList();
            for (int i = 0; i < productsResponse.getTotal(); ++i) {
                Item item = productsResponse.getResults()[i];
                ProductInfo productInfo = new ProductInfo().setProductId(item.getSlug()).setTitle(item.getName()).setDescription(item.getDescription());
                if (item.getType().equalsIgnoreCase("IAP")) {
                    productInfo.setItemType(ItemType.inapp.name());
                } else {
                    productInfo.setItemType(ItemType.subs.name());
                }
                productInfo.setConsumable(item.isConsumable() != false && productInfo.getItemType().equalsIgnoreCase(ItemType.inapp.name()));
                Catalog.this.parsingPrices(productInfo, item.getPriceSets());
                Catalog.this.put(productInfo.getProductId(), productInfo);
            }
        }

        private Future<String> getAccessToken() {
            return Catalog.this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    PostTokenRequest request = new PostTokenRequest();
                    request.setClient_id(Catalog.this.appInfo.getClientId());
                    request.setClient_secret(Catalog.this.appInfo.getClientSecret());
                    String deviceId = Utils.getAndroidID(Catalog.this.context);
                    deviceId = deviceId == null ? Utils.getSerialNumber() : deviceId;
                    request.setExternal_id(deviceId);
                    request.setExternal_token(deviceId);
                    PostTokenResponse response = UnityChannelRestClient.getInstance().postToken(request);
                    String accessToken = response.getAccess_token();
                    return accessToken;
                }
            });
        }

        private Future<GetAllProductsResponse> fetchProducts() {
            return Catalog.this.executor.submit(new Callable<GetAllProductsResponse>(){

                @Override
                public GetAllProductsResponse call() throws Exception {
                    HashMap<String, String> queryParam = new HashMap<String, String>();
                    queryParam.put("token", Catalog.this.cachedAccessToken);
                    GetAllProductsResponse productsResponse = UnityChannelRestClient.getInstance().getAllProducts(Catalog.this.appInfo.getAppSlug(), queryParam);
                    return productsResponse;
                }
            });
        }
    }
}

