/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.unity.udp.sdk.AppInfo;
import com.unity.udp.sdk.DeviceInfo;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.InventoryInfo;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.ResultCode;
import com.unity.udp.sdk.UserInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.Catalog;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.internal.runnable.CreateOrderRunnable;
import com.unity.udp.sdk.internal.runnable.OrderCheckCallable;
import com.unity.udp.sdk.internal.runnable.PostInitRunnable;
import com.unity.udp.sdk.internal.runnable.PostLoginRunnable;
import com.unity.udp.sdk.provider.ChannelProviderService;
import com.unity.udp.sdk.rest.LoginAttemptRequest;
import com.unity.udp.sdk.rest.OrderAttempt;
import com.unity.udp.sdk.rest.OrderCheckRequest;
import com.unity.udp.sdk.rest.OrderQueryToken;
import com.unity.udp.sdk.rest.PostInitRequest;
import com.unity.udp.sdk.rest.UserLoginToken;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ChannelHandler
extends Handler {
    ChannelProviderService providerService;
    UserInfo userInfo = null;
    private AppInfo appInfo;
    private boolean initSuccessful = false;
    private Catalog catalog;
    private Map<String, String> itemSlugMap = new HashMap<String, String>();
    private Map<String, String> productIdMap = new HashMap<String, String>();
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private HashMap<String, String> otherInfo;

    public ChannelHandler(AppInfo appInfo, ChannelProviderService providerService) {
        super(Looper.getMainLooper());
        this.appInfo = appInfo;
        this.providerService = providerService;
        this.catalog = new Catalog(providerService.getProviderName(), (Context)UnityPlayer.currentActivity, appInfo);
    }

    public ChannelHandler(AppInfo appInfo, ChannelProviderService providerService, HashMap<String, String> otherInfo) {
        this(appInfo, providerService);
        this.otherInfo = otherInfo;
    }

    public boolean hasInitSuccess() {
        return this.initSuccessful;
    }

    public void startInit(final InitCallback initCallback) {
        Logger.logInfo((String)"Initializing.");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Future future = ChannelHandler.this.catalog.update();
                Logger.logError((String)"[DEBUG] provider service init");
                ChannelHandler.this.providerService.init(UnityPlayer.currentActivity, ChannelHandler.this.appInfo, ChannelHandler.this, ChannelHandler.this.otherInfo, initCallback);
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Logger.logError((String)e.getMessage());
                }
                catch (ExecutionException e) {
                    Logger.logError((String)e.getMessage());
                }
            }
        });
    }

    public void startPurchase(PurchaseInfo purchaseInfo, PurchaseCallback callback) {
        Logger.logDebug((String)("Generate cpOrderId/gameOrderId: " + purchaseInfo.getGameOrderId()));
        purchaseInfo.setStore(this.providerService.getProviderName());
        if (this.itemSlugMap.size() > 0 && this.itemSlugMap.containsKey(purchaseInfo.getProductId())) {
            purchaseInfo.setProductId(this.itemSlugMap.get(purchaseInfo.getProductId()));
        }
        this.assembleOrderQueryToken(purchaseInfo);
        this.assemblePostOrder(purchaseInfo, false, 0);
        Logger.logInfo((String)"Purchasing");
        this.providerService.purchase(UnityPlayer.currentActivity, purchaseInfo, callback);
    }

    public void startConsume(PurchaseInfo purchaseInfo, PurchaseCallback callback) {
        Logger.logInfo((String)"Consuming");
        this.providerService.consumePurchase(purchaseInfo, callback);
    }

    public void startConsume(List<PurchaseInfo> purchaseInfos, PurchaseCallback callback) {
        Logger.logInfo((String)"Consuming");
        this.providerService.consumePurchases(purchaseInfos, callback);
    }

    public void startQueryInventory(String[] productIds, PurchaseCallback callback) {
        Logger.logInfo((String)"Querying Inventory");
        this.providerService.queryInventory(productIds, callback);
    }

    public void handleMessage(Message msg) {
        int action = msg.what;
        Map map = (Map)msg.obj;
        String channel = (String)map.get("CHANNEL");
        Integer code = (Integer)map.get("RESULT");
        String message = (String)map.get("MESSAGE");
        switch (action) {
            case 1000: {
                String uid = (String)map.get("UID");
                String token = (String)map.get("LOGINTOKEN");
                this.handleInitMessage(code, message, uid, token, (InitCallback)map.get("UDPCALLBACK"));
                break;
            }
            case 3000: {
                String purchaseJsonString;
                PurchaseInfo genPurchaseInfo = null;
                if (map.containsKey("PURCHASEJSONSTRING") && !Utils.isEmptyString(purchaseJsonString = (String)map.get("PURCHASEJSONSTRING"))) {
                    try {
                        genPurchaseInfo = Utils.getPurchaseInfoFromStorePurchaseJsonString(this, channel, purchaseJsonString);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.handlePurchaseMessage(genPurchaseInfo, code, message, (PurchaseCallback)map.get("UDPCALLBACK"));
                break;
            }
            case 6000: {
                String purchaseJsonString = (String)map.get("PURCHASEJSONSTRING");
                this.handleConsumeMessage(code, message, Utils.getPurchaseInfoFromStorePurchaseJsonString(this, channel, purchaseJsonString), (PurchaseCallback)map.get("UDPCALLBACK"));
                break;
            }
            case 7000: {
                InventoryInfo inventoryInfo = (InventoryInfo)map.get("INVENTORYINFO");
                this.handleQueryInventoryMessage(code, message, inventoryInfo, (PurchaseCallback)map.get("UDPCALLBACK"));
            }
        }
    }

    private void handleQueryInventoryMessage(Integer code, String message, InventoryInfo inventoryInfo, PurchaseCallback purchaseCallback) {
        if (inventoryInfo != null) {
            purchaseCallback.onQueryInventory(code, message, inventoryInfo.toJsonObject().toString());
        } else {
            purchaseCallback.onQueryInventory(code, message, "");
        }
    }

    private void handleInitMessage(Integer code, String message, String uid, String loginToken, InitCallback initCallback) {
        if (ResultCode.SDK_INIT_SUCCESS.equals(code)) {
            this.initSuccessful = true;
            Logger.logInfo((String)"Init Succeed");
        } else {
            Logger.logInfo((String)("Init Fail: " + message));
        }
        Activity activity = UnityPlayer.currentActivity;
        PostInitRequest request = new PostInitRequest();
        request.setPackageName(Utils.getPackageName());
        request.setAppName(Utils.getAppName((Context)activity));
        request.setType(PostInitRequest.deviceIdType.androidID.toString());
        request.setDeviceId(Utils.getAndroidID(activity.getApplicationContext()));
        request.setChannelType(this.providerService.getProviderName());
        if (request.getDeviceId() == null || request.getDeviceId().trim().equals("")) {
            request.setType(PostInitRequest.deviceIdType.serialNumber.toString());
            request.setDeviceId(Utils.getSerialNumber());
        }
        request.setClientId(this.appInfo.getClientId());
        request.setDeviceInfo(DeviceInfo.getDeviceInfoJsonString((Context)activity));
        Logger.logInfo((String)String.format("UDP Version: %s", "v1.2.0"));
        Logger.logDebug((String)String.format("DeviceId(%s): %s, ClientId: %s", request.getType(), request.getDeviceId(), request.getClientId()));
        new Thread(new PostInitRunnable(request)).start();
        UserLoginToken userLoginToken = new UserLoginToken();
        userLoginToken.setExternalSession(loginToken);
        userLoginToken.setExternalUid(uid);
        userLoginToken.setExternalType(this.providerService.getProviderName());
        userLoginToken.setLoginTime(Utils.getUTCTime());
        if (ResultCode.SDK_INIT_SUCCESS.equals(code) && !Utils.isEmptyString(uid) && !Utils.isEmptyString(loginToken)) {
            LoginAttemptRequest loginRequest = new LoginAttemptRequest();
            loginRequest.setClientId(this.appInfo.getClientId());
            loginRequest.setClientSecret(this.appInfo.getClientSecret());
            loginRequest.setDeviceInfo(DeviceInfo.getDeviceInfoJsonString((Context)activity));
            loginRequest.setLoginReceipt(userLoginToken.genLoginToken());
            new Thread(new PostLoginRunnable(loginRequest)).start();
        }
        if (uid != null) {
            this.userInfo = new UserInfo();
            this.userInfo.setUserId(uid);
            this.userInfo.setUserToken(loginToken);
            this.userInfo.setChannel(this.providerService.getProviderName());
            this.userInfo.setLoginReceipt(userLoginToken.genLoginToken());
        }
        initCallback.onInitFinished(code, message, this.userInfo);
    }

    private void handlePurchaseMessage(PurchaseInfo purchaseInfo, Integer result, String message, PurchaseCallback purchaseCallback) {
        if (message == null) {
            message = "";
        }
        if (purchaseInfo == null) {
            if (purchaseCallback != null) {
                purchaseCallback.onPurchaseFinished(result, message, "");
            }
            return;
        }
        this.assemblePostOrder(purchaseInfo, true, result);
        if (result.equals(ResultCode.SDK_PURCHASE_SUCCESS)) {
            this.assembleOrderCheckRequest(purchaseInfo);
            Logger.logInfo((String)"Purchase Succeeded");
        } else {
            Logger.logInfo((String)"Purchase Failed");
        }
        String itemSlug = this.productIdMap.get(purchaseInfo.getProductId());
        if (!Utils.isEmptyString(itemSlug)) {
            purchaseInfo.setProductId(itemSlug);
        }
        purchaseCallback.onPurchaseFinished(result, message, purchaseInfo.toJsonObject().toString());
    }

    private void handleConsumeMessage(Integer result, String message, PurchaseInfo purchaseInfo, PurchaseCallback purchaseCallback) {
        if (message == null) {
            message = "";
        }
        if (result.equals(ResultCode.SDK_CONSUME_PURCHASE_SUCCESS)) {
            Logger.logInfo((String)"Consume Succeeded");
        } else {
            Logger.logInfo((String)("Consume Failed: " + message));
        }
        if (purchaseCallback != null) {
            purchaseCallback.onConsumeFinished(result, message, purchaseInfo.toJsonObject().toString());
        }
    }

    private void assembleOrderCheckRequest(PurchaseInfo purchaseInfo) {
        if (Utils.isEmptyString(purchaseInfo.getStorePurchaseJsonString())) {
            return;
        }
        OrderCheckRequest request = new OrderCheckRequest();
        request.setClientId(this.appInfo.getClientId());
        request.setCpOrderId(purchaseInfo.getGameOrderId());
        request.setChannelType(this.providerService.getProviderName());
        this.providerService.getHelper().setOrderCheckRequest(purchaseInfo, request);
        this.executorService.submit(new OrderCheckCallable(request));
    }

    private void assemblePostOrder(PurchaseInfo purchaseInfo, boolean sendResult, Integer result) {
        OrderAttempt orderAttempt = new OrderAttempt();
        orderAttempt.setClientId(this.appInfo.getClientId());
        orderAttempt.setCpOrderId(purchaseInfo.getGameOrderId());
        orderAttempt.setProductId(purchaseInfo.getProductId());
        orderAttempt.setDeveloperPayload(purchaseInfo.getDeveloperPayload());
        if (this.userInfo != null && this.userInfo.getUserId() != null) {
            orderAttempt.setUid(this.userInfo.getUserId());
        }
        orderAttempt.setAuthenticatorType(this.providerService.getProviderName());
        new Thread(new CreateOrderRunnable(orderAttempt)).start();
    }

    private void assembleOrderQueryToken(PurchaseInfo purchaseInfo) {
        OrderQueryToken oqt = new OrderQueryToken();
        oqt.setChannelProductId(purchaseInfo.getProductId());
        oqt.setClientId(this.appInfo.getClientId());
        oqt.setCpOrderId(purchaseInfo.getGameOrderId());
        oqt.setPackageName(Utils.getPackageName());
        oqt.setChannelType(this.providerService.getProviderName());
        if (this.userInfo != null) {
            oqt.setChannelUid(this.userInfo.getUserId());
        }
        purchaseInfo.setOrderQueryToken(oqt.genOrderQueryToken());
    }

    public String getItemSlug(String productId) {
        return this.productIdMap.containsKey(productId) ? this.productIdMap.get(productId) : productId;
    }

    public ChannelProviderService getProviderService() {
        return this.providerService;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }
}

