/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.common.rest.BaseModel;
import com.unity3d.player.UnityPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPurchaseCache {
    private static LocalPurchaseCache instance;
    private final String preference_file_key = "com.unity3d.udp.sdk.udpSharedPref";
    private final SharedPreferences sharedPref;

    private LocalPurchaseCache() {
        Context context = UnityPlayer.currentActivity.getApplicationContext();
        this.sharedPref = context.getSharedPreferences("com.unity3d.udp.sdk.udpSharedPref", 0);
    }

    public static LocalPurchaseCache getInstance() {
        if (instance == null) {
            instance = new LocalPurchaseCache();
        }
        return instance;
    }

    public boolean addPurchase(PurchaseInfo purchase) {
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.putString(purchase.getGameOrderId(), purchase.toString());
        editor.apply();
        return true;
    }

    public boolean addPurchase(String key, PurchaseInfo purchase) {
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.putString(key, purchase.toString());
        editor.apply();
        return true;
    }

    public boolean removePurchase(PurchaseInfo purchase) {
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.remove(purchase.getGameOrderId());
        editor.apply();
        return true;
    }

    public boolean removePurchase(String key) {
        SharedPreferences.Editor editor = this.sharedPref.edit();
        editor.remove(key);
        editor.apply();
        return true;
    }

    public PurchaseInfo getPurchase(String gameOrderId) {
        String purchaseInfoJson = this.sharedPref.getString(gameOrderId, "null");
        if (purchaseInfoJson.equals("null")) {
            return null;
        }
        try {
            PurchaseInfo pf = (PurchaseInfo)BaseModel.fromJsonObject(PurchaseInfo.class, (JSONObject)new JSONObject(purchaseInfoJson));
            return pf;
        }
        catch (JSONException e) {
            Logger.logError((String)"LocalPurchaseCache Json Error");
            return null;
        }
    }

    public List<PurchaseInfo> getAllPurchases() {
        ArrayList<PurchaseInfo> result = new ArrayList<PurchaseInfo>();
        Map allEntries = this.sharedPref.getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            try {
                result.add((PurchaseInfo)PurchaseInfo.fromJsonObject(PurchaseInfo.class, (JSONObject)new JSONObject((String)entry.getValue())));
            }
            catch (JSONException e) {
                Logger.logError((String)e.getMessage());
            }
        }
        return result;
    }
}

