/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.Base64;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.InventoryInfo;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.provider.ChannelProviderHelper;
import com.unity3d.player.UnityPlayer;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static Bundle manifestBundle = null;
    private static String appName = null;
    private static String packageName = null;
    private static String serialNumber = null;
    private static String androidID = null;
    private static final String VALUE_PREFIX = "string:";
    public static final String APP_ID = "appId";
    public static final String APP_KEY = "appKey";
    public static final String ASSET_FILE_NAME = "UDPCatalog.json";
    public static final String CHANNEL = "CHANNEL";
    public static final String EXTERNAL_TYPE = "DEVICE_PLAYER";
    public static final String GRANT_TYPE = "CLIENT_CREDENTIALS_PLAYER";
    public static final String HASH_KEY = "hashKey";
    public static final String INVENTORY_INFO = "INVENTORYINFO";
    public static final String LOGIN_TOKEN = "LOGINTOKEN";
    public static final String MANIFEST_CHANNEL_NAME_STRING = "CHANNEL_NAME";
    public static final String MANIFEST_RSA_STRING = "publicKey";
    public static final String MESSAGE = "MESSAGE";
    public static final String PURCHASE_JSON_STRING = "PURCHASEJSONSTRING";
    public static final String RESULT_CODE = "RESULT";
    public static final String SCOPE = "player offline";
    public static final String UDPCALLBACK = "UDPCALLBACK";
    public static final String UID = "UID";
    public static int[] RETRY_WAIT_TIME = new int[]{0, 3, 10, 60, 180, 300};

    public static String getUTCTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return sdf.format(new Date());
    }

    public static String getAppName(Context context) {
        if (appName == null) {
            try {
                ApplicationInfo appInfo = context.getApplicationInfo();
                int stringId = appInfo.labelRes;
                appName = stringId == 0 ? appInfo.nonLocalizedLabel.toString() : context.getString(stringId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appName;
    }

    public static String getPackageName() {
        Context context = UnityPlayer.currentActivity.getApplicationContext();
        if (packageName == null) {
            try {
                String tmp = context.getPackageName();
                packageName = tmp == null ? "UNKNOWN" : tmp;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return packageName;
    }

    public static String getSerialNumber() {
        if (serialNumber == null) {
            String tmpSerialNumber = "UNKNOWN";
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class, String.class);
                tmpSerialNumber = (String)get.invoke(c, "ro.serialno", "unknown");
            }
            catch (Exception exception) {
                // empty catch block
            }
            serialNumber = tmpSerialNumber;
        }
        return serialNumber;
    }

    public static String getAndroidID(Context context) {
        if (androidID == null) {
            androidID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return androidID;
    }

    public static void sendInitMessage(Handler handler, String channel, Integer code, String msg, String uid, String loginToken, InitCallback callback) {
        Message message = new Message();
        message.what = 1000;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNEL, channel);
        map.put(RESULT_CODE, code);
        map.put(MESSAGE, msg);
        map.put(UID, uid);
        map.put(LOGIN_TOKEN, loginToken);
        map.put(UDPCALLBACK, callback);
        message.obj = map;
        handler.sendMessage(message);
    }

    public static void sendPurchaseMessage(Handler handler, String channel, Integer code, String purchaseJsonString, String msg, PurchaseCallback callback) {
        Message message = new Message();
        message.what = 3000;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNEL, channel);
        map.put(RESULT_CODE, code);
        map.put(MESSAGE, msg);
        map.put(PURCHASE_JSON_STRING, purchaseJsonString);
        map.put(UDPCALLBACK, callback);
        message.obj = map;
        handler.sendMessage(message);
    }

    public static void sendConsumeMessage(Handler handler, String channel, Integer code, String purchaseJsonString, String message, PurchaseCallback callback) {
        Message handlerMessage = new Message();
        handlerMessage.what = 6000;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNEL, channel);
        map.put(RESULT_CODE, code);
        map.put(MESSAGE, message);
        map.put(PURCHASE_JSON_STRING, purchaseJsonString);
        map.put(UDPCALLBACK, callback);
        handlerMessage.obj = map;
        handler.sendMessage(handlerMessage);
    }

    public static void sendQueryInventoryMessage(ChannelHandler handler, String channel, Integer code, InventoryInfo inventoryInfo, String message, PurchaseCallback callback) {
        Message handlerMessage = new Message();
        handlerMessage.what = 7000;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNEL, channel);
        map.put(RESULT_CODE, code);
        map.put(MESSAGE, message);
        map.put(INVENTORY_INFO, inventoryInfo);
        map.put(UDPCALLBACK, callback);
        handlerMessage.obj = map;
        handler.sendMessage(handlerMessage);
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.equals("");
    }

    public static PurchaseInfo getPurchaseInfoFromStorePurchaseJsonString(ChannelHandler handler, String channel, String storePurchaseJsonString) {
        if (Utils.isEmptyString(storePurchaseJsonString)) {
            return null;
        }
        ChannelProviderHelper helper = handler.providerService.getHelper();
        return helper.purchase2PurchaseInfo(handler, helper.jsonString2Purchase(storePurchaseJsonString));
    }

    public static boolean verifyRsa(String signData, String sign, String key) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        byte[] keyBytes = Base64.decode((String)key, (int)2);
        X509EncodedKeySpec pkcs8KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory fact = KeyFactory.getInstance("RSA");
        PublicKey pubKey = fact.generatePublic(pkcs8KeySpec);
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(pubKey);
        signature.update(signData.getBytes());
        return signature.verify(Base64.decode((String)sign, (int)2));
    }

    public static void parseUDPCatalog(JSONObject UDPCatalog, String store, Map<String, String> itemSlugMap, Map<String, String> productIdMap) {
        if (UDPCatalog == null) {
            return;
        }
        itemSlugMap.clear();
        productIdMap.clear();
        Iterator itemSlugs = UDPCatalog.keys();
        while (itemSlugs.hasNext()) {
            String itemSlug = (String)itemSlugs.next();
            try {
                JSONObject storeProductIds = UDPCatalog.getJSONObject(itemSlug);
                String productId = storeProductIds.getString(store);
                itemSlugMap.put(itemSlug, productId);
                productIdMap.put(productId, itemSlug);
            }
            catch (JSONException e) {
                Logger.logError((String)"Cannot Parse UDPCatalog!");
            }
        }
    }

    public static String getAndroidMetadata(Context context, String key) throws PackageManager.NameNotFoundException {
        String value;
        if (manifestBundle == null) {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            manifestBundle = ai.metaData;
        }
        if ((value = String.valueOf(manifestBundle.get(key))).startsWith(VALUE_PREFIX)) {
            value = value.substring(VALUE_PREFIX.length());
        }
        return value;
    }
}

