/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.provider;

import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.provider.ChannelProviderActivityLifecycle;
import com.unity.udp.sdk.provider.ChannelProviderApplicationExtension;
import com.unity.udp.sdk.provider.ChannelProviderService;

public class ChannelProvider {
    private static Object getClass(String channelName, String extension) {
        channelName = channelName.toLowerCase();
        String capChannelName = channelName.substring(0, 1).toUpperCase() + channelName.substring(1);
        String className = String.format("com.unity.udp.sdk.provider.%s.%s%s", channelName, capChannelName, extension);
        Object service = null;
        try {
            Class<?> clazz = Class.forName(className);
            service = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            Logger.logError((String)("Cannot find specific class " + className));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            Logger.logError((String)("Instantiation Exception: " + e.getMessage()));
        }
        return service;
    }

    public static ChannelProviderService getChannelProviderService(String channelName) {
        return (ChannelProviderService)ChannelProvider.getClass(channelName, "ProviderService");
    }

    public static ChannelProviderActivityLifecycle getChannelProviderLifeCycle(String channelName) {
        return new ChannelProviderActivityLifecycle(){};
    }

    public static ChannelProviderApplicationExtension getApplicationExtension(String channelName) {
        ChannelProviderApplicationExtension applicationExtension = (ChannelProviderApplicationExtension)ChannelProvider.getClass(channelName, "ApplicationExtension");
        if (applicationExtension != null) {
            return applicationExtension;
        }
        return new ChannelProviderApplicationExtension(){};
    }
}

