/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.rest;

import com.unity.udp.sdk.common.rest.HttpMethod;
import com.unity.udp.sdk.common.rest.RestClient;
import com.unity.udp.sdk.common.rest.RestResponse;
import com.unity.udp.sdk.rest.GetAllProductsResponse;
import com.unity.udp.sdk.rest.LoginAttemptRequest;
import com.unity.udp.sdk.rest.LoginAttemptResponse;
import com.unity.udp.sdk.rest.OrderAttempt;
import com.unity.udp.sdk.rest.OrderCheckRequest;
import com.unity.udp.sdk.rest.OrderReceipt;
import com.unity.udp.sdk.rest.PostInitRequest;
import com.unity.udp.sdk.rest.PostTokenRequest;
import com.unity.udp.sdk.rest.PostTokenResponse;
import java.util.Map;

public class UnityChannelRestClient
extends RestClient {
    private static String GET_ALL_PRODUCTS_URL = UnityChannelRestClient.combinePaths((String)"https://api-udp.unity.com", (String[])new String[]{"/v1/player/store/items/slug"});
    private static String POST_TOKEN_URL = UnityChannelRestClient.combinePaths((String)"https://api-udp.unity.com", (String[])new String[]{"/v1/oauth2/token"});

    private UnityChannelRestClient() {
        this.baseUrl = "https://distribute.dashboard.unity.com";
    }

    public static UnityChannelRestClient getInstance() {
        if (instance == null) {
            instance = new UnityChannelRestClient();
        }
        return (UnityChannelRestClient)instance;
    }

    public PostTokenResponse postToken(PostTokenRequest request) throws RuntimeException {
        RestResponse restResponse = this.execute(HttpMethod.POST, POST_TOKEN_URL, request, null, null, PostTokenResponse.class, "application/x-www-form-urlencoded; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (PostTokenResponse)((Object)restResponse.getEntity());
    }

    public GetAllProductsResponse getAllProducts(String appItemSlug, Map<String, String> queryParam) {
        String url = String.format("%s/%s/iap", GET_ALL_PRODUCTS_URL, appItemSlug);
        RestResponse restResponse = this.execute(HttpMethod.GET, url, null, null, queryParam, GetAllProductsResponse.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (GetAllProductsResponse)((Object)restResponse.getEntity());
    }

    public OrderAttempt createOrder(OrderAttempt orderAttempt) {
        RestResponse restResponse = this.execute(HttpMethod.POST, "/v1/order-attempts", orderAttempt, null, null, OrderAttempt.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (OrderAttempt)((Object)restResponse.getEntity());
    }

    public LoginAttemptResponse loginAttempt(LoginAttemptRequest request) {
        RestResponse restResponse = this.execute(HttpMethod.POST, "/v1/login-attempts", request, null, null, LoginAttemptResponse.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (LoginAttemptResponse)((Object)restResponse.getEntity());
    }

    public void orderCheck(OrderCheckRequest request) {
        RestResponse restResponse = this.execute(HttpMethod.POST, "/v1/order-attempts/check", request, null, null, null, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
    }

    public void InitAttempt(PostInitRequest request) {
        RestResponse restResponse = this.execute(HttpMethod.POST, "/v1/login-attempts/init", request, null, null, PostInitRequest.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
    }

    public OrderReceipt getOrderReceipt(String orderId, String clientId, String receiptQueryToken) {
        RestResponse restResponse = this.execute(HttpMethod.GET, "/v1/order-attempts/receipt?cpOrderId=" + orderId + "&clientId=" + clientId + "&receiptQueryToken=" + receiptQueryToken, null, null, null, OrderReceipt.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (OrderReceipt)((Object)restResponse.getEntity());
    }

    public OrderAttempt getOrderByCpOrderId(String orderId, String clientId, String channelName) {
        RestResponse restResponse = this.execute(HttpMethod.GET, "/v1/order-attempts?cpOrderId=" + orderId + "&clientId=" + clientId + "&channelType=" + channelName, null, null, null, OrderAttempt.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (OrderAttempt)((Object)restResponse.getEntity());
    }
}

