/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.provider.udp;

import com.unity.udp.sdk.ProductInfo;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProviderHelper;
import com.unity.udp.sdk.rest.OrderCheckRequest;
import com.unity.udp.sdk.rest.OrderQueryToken;
import com.unity.udp.udpsandbox.Product;
import com.unity.udp.udpsandbox.Purchase;
import org.json.JSONException;
import org.json.JSONObject;

public class UdpHelper
implements ChannelProviderHelper<Purchase, Product> {
    private static UdpHelper instance;

    private UdpHelper() {
    }

    public static UdpHelper getInstance() {
        if (instance == null) {
            instance = new UdpHelper();
        }
        return instance;
    }

    public PurchaseInfo purchase2PurchaseInfo(ChannelHandler handler, Purchase purchase) {
        PurchaseInfo.Builder builder = new PurchaseInfo.Builder(purchase.getProductId(), purchase.getCpOrderId());
        OrderQueryToken ort = new OrderQueryToken();
        ort.setChannelProductId(purchase.getProductId());
        ort.setChannelType("UDP");
        ort.setPackageName(Utils.getPackageName());
        ort.setClientId(handler.getAppInfo().getClientId());
        ort.setCpOrderId(purchase.getCpOrderId());
        builder.orderQueryToken(ort.genOrderQueryToken()).store("UDP").developerPayload(purchase.getDeveloperPayload()).storePurchaseJsonString(this.purchase2JsonString(purchase));
        return builder.build();
    }

    public Purchase purchaseInfo2Purchase(PurchaseInfo purchaseInfo) {
        return this.jsonString2Purchase(purchaseInfo.getStorePurchaseJsonString());
    }

    public String purchase2JsonString(Purchase purchase) {
        return purchase.toString();
    }

    public Purchase jsonString2Purchase(String storeJsonString) {
        try {
            return (Purchase)Purchase.fromJsonObject(Purchase.class, (JSONObject)new JSONObject(storeJsonString));
        }
        catch (JSONException e) {
            Logger.logError((String)"Error on parsing storeJsonString");
            return null;
        }
    }

    public ProductInfo product2ProductInfo(ChannelHandler handler, Product product) {
        ProductInfo productInfo = new ProductInfo();
        productInfo.setTitle(product.getTitle());
        productInfo.setConsumable(product.isConsumable());
        productInfo.setProductId(product.getProductId());
        productInfo.setPrice(product.getPrice());
        productInfo.setDescription(product.getDescription());
        productInfo.setCurrency(product.getCurrency());
        productInfo.setPriceAmountMicros(product.getPriceAmountMicros());
        productInfo.setItemType(product.getType());
        return productInfo;
    }

    public void setOrderCheckRequest(PurchaseInfo purchaseInfo, OrderCheckRequest request) {
    }
}

