/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.udpsandbox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.udpsandbox.AccessToken;
import com.unity.udp.udpsandbox.AppInfo;
import com.unity.udp.udpsandbox.IUDPPurchaseCallback;
import com.unity.udp.udpsandbox.IUDPPurchasingService;
import com.unity.udp.udpsandbox.LoginActivity;
import com.unity.udp.udpsandbox.Product;
import com.unity.udp.udpsandbox.Purchase;
import com.unity.udp.udpsandbox.Utils;
import com.unity.udp.udpsandbox.rest.UdpSandboxRestClient;
import com.unity.udp.udpsandbox.rest.model.ConsumeRequest;
import com.unity.udp.udpsandbox.rest.model.GetAllProductsResponse;
import com.unity.udp.udpsandbox.rest.model.GetPurchaseRequest;
import com.unity.udp.udpsandbox.rest.model.GetPurchaseResponse;
import com.unity.udp.udpsandbox.rest.model.OrderItem;
import com.unity.udp.udpsandbox.rest.model.PurchaseRequest;
import com.unity.udp.udpsandbox.rest.model.PurchaseResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class UDPPurchasing
implements IUDPPurchasingService {
    private static UDPPurchasing instance;
    private AppInfo appInfo;
    private AccessToken accessToken = new AccessToken();
    private IUDPPurchaseCallback callback;

    private UDPPurchasing() {
    }

    public static UDPPurchasing getInstance() {
        if (instance == null) {
            instance = new UDPPurchasing();
        }
        return instance;
    }

    @Override
    public void init(Context context, AppInfo appInfo, IUDPPurchaseCallback callback) {
        if (callback == null) {
            Logger.logError((String)"IUDPPurchaseCallback cannot be null");
            return;
        }
        if (appInfo == null) {
            Logger.logError((String)"AppInfo cannot be null");
            callback.onInitFailed("AppInfo cannot be null");
            return;
        }
        this.callback = callback;
        this.appInfo = appInfo;
        Intent intent = new Intent(context, LoginHelperActivity.class);
        context.startActivity(intent);
    }

    @Override
    public void purchase(final String productId, final String cpOrderId, final String developerPayload, final IUDPPurchaseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PurchaseRequest req = new PurchaseRequest();
                    req.setDeveloperPayload(developerPayload);
                    req.setCpOrderId(cpOrderId);
                    OrderItem orderItem = new OrderItem();
                    orderItem.setItemSlug(productId);
                    orderItem.setMasterItemSlug(UDPPurchasing.this.appInfo.getAppSlug());
                    orderItem.setQuantity(1);
                    orderItem.setClientId(UDPPurchasing.this.appInfo.getClientId());
                    OrderItem[] items = new OrderItem[]{orderItem};
                    req.setOrderItems(items);
                    HashMap<String, String> queryParam = new HashMap<String, String>();
                    queryParam.put("token", UDPPurchasing.this.accessToken.getAccessToken());
                    PurchaseResponse response = UdpSandboxRestClient.getInstance().purchase(req, queryParam);
                    Purchase purchase = Utils.purchaseResponse2Purchase(response);
                    callback.onPurchaseSucceeded(purchase);
                }
                catch (Exception e) {
                    Purchase purchase = new Purchase();
                    purchase.setProductId(productId);
                    purchase.setDeveloperPayload(developerPayload);
                    purchase.setCpOrderId(cpOrderId);
                    callback.onPurchaseFailed(Utils.parsingException(e), purchase);
                }
            }
        }).start();
    }

    @Override
    public void consumePurchase(final Purchase purchase, final IUDPPurchaseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConsumeRequest request = new ConsumeRequest(purchase.getOrderId(), purchase.getProductId());
                    HashMap<String, String> queryParam = new HashMap<String, String>();
                    queryParam.put("token", UDPPurchasing.this.accessToken.getAccessToken());
                    UdpSandboxRestClient.getInstance().consume(request, queryParam);
                    callback.onConsumeSucceeded(purchase);
                }
                catch (Exception e) {
                    callback.onConsumeFailed(Utils.parsingException(e), purchase);
                }
            }
        }).start();
    }

    public void consumePurchases(final List<Purchase> purchases, final IUDPPurchaseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < purchases.size(); ++i) {
                    try {
                        ConsumeRequest request = new ConsumeRequest(((Purchase)((Object)purchases.get(i))).getOrderId(), ((Purchase)((Object)purchases.get(i))).getProductId());
                        HashMap<String, String> queryParam = new HashMap<String, String>();
                        queryParam.put("token", UDPPurchasing.this.accessToken.getAccessToken());
                        UdpSandboxRestClient.getInstance().consume(request, queryParam);
                        callback.onConsumeSucceeded((Purchase)((Object)purchases.get(i)));
                        continue;
                    }
                    catch (Exception e) {
                        callback.onConsumeFailed(Utils.parsingException(e), (Purchase)((Object)purchases.get(i)));
                    }
                }
            }
        }).start();
    }

    @Override
    public void getPurchases(final IUDPPurchaseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GetPurchaseRequest request = new GetPurchaseRequest(UDPPurchasing.this.appInfo.getAppSlug());
                    request.setClientId(UDPPurchasing.this.appInfo.getClientId());
                    GetPurchaseResponse response = UdpSandboxRestClient.getInstance().getPurchase(request, UDPPurchasing.this.accessToken.getAccessToken());
                    List<Purchase> purchases = Utils.getPurchaseResponse2Purchases(response);
                    callback.onGetPurchaseSucceeded(purchases);
                }
                catch (Exception e) {
                    callback.onGetPurchaseFailed(Utils.parsingException(e));
                }
            }
        }).start();
    }

    @Override
    public void getProducts(final String[] productIds, final IUDPPurchaseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Product> products = new ArrayList();
                    HashMap<String, String> queryParam = new HashMap<String, String>();
                    queryParam.put("token", UDPPurchasing.this.accessToken.getAccessToken());
                    GetAllProductsResponse response = UdpSandboxRestClient.getInstance().getAllProducts(UDPPurchasing.this.appInfo.getAppSlug(), queryParam);
                    List<Product> allProducts = Utils.getProductsResponse2Products(response);
                    if (productIds != null && productIds.length != 0) {
                        Arrays.sort(productIds);
                        for (Product product : allProducts) {
                            if (Arrays.binarySearch(productIds, product.getProductId()) < 0) continue;
                            products.add(product);
                        }
                    } else {
                        products = allProducts;
                    }
                    callback.onGetProductsSucceeded(products);
                }
                catch (Exception e) {
                    callback.onGetProductsFailed(Utils.parsingException(e));
                }
            }
        }).start();
    }

    @Override
    public void getPurchaseHistory() {
    }

    static /* synthetic */ IUDPPurchaseCallback access$200(UDPPurchasing x0) {
        return x0.callback;
    }

    public static class LoginHelperActivity
    extends Activity {
        UDPPurchasing purchasing = UDPPurchasing.getInstance();
        AppInfo appInfo = UDPPurchasing.access$000(this.purchasing);
        AccessToken accessToken = UDPPurchasing.access$100(this.purchasing);
        IUDPPurchaseCallback callback = UDPPurchasing.access$200(this.purchasing);

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            Intent intent = new Intent((Context)this, LoginActivity.class);
            intent.putExtra("client_id", this.appInfo.getClientId());
            intent.putExtra("client_secret", this.appInfo.getClientSecret());
            this.startActivityForResult(intent, 0);
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (resultCode == -1) {
                this.accessToken.setAccessToken(data.getStringExtra("access_token"));
                this.accessToken.setRefreshToken(data.getStringExtra("refresh_token"));
                String userId = data.getStringExtra("user_id");
                this.callback.onInitSucceeded(userId);
            } else {
                this.callback.onInitFailed("Login Failed");
            }
            this.finish();
        }
    }
}

