/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.udpsandbox.rest;

import com.unity.udp.sdk.common.rest.HttpMethod;
import com.unity.udp.sdk.common.rest.RestClient;
import com.unity.udp.sdk.common.rest.RestResponse;
import com.unity.udp.udpsandbox.rest.model.ConsumeRequest;
import com.unity.udp.udpsandbox.rest.model.GetAllProductsResponse;
import com.unity.udp.udpsandbox.rest.model.GetPurchaseRequest;
import com.unity.udp.udpsandbox.rest.model.GetPurchaseResponse;
import com.unity.udp.udpsandbox.rest.model.PostTokenRequest;
import com.unity.udp.udpsandbox.rest.model.PostTokenResponse;
import com.unity.udp.udpsandbox.rest.model.PurchaseRequest;
import com.unity.udp.udpsandbox.rest.model.PurchaseResponse;
import java.util.Map;

public class UdpSandboxRestClient
extends RestClient {
    private static UdpSandboxRestClient instance = null;
    private static String API_VERSION = "/v1";
    private static String POST_TOKEN_URL = "/oauth2/token";
    private static String PURCHASE_URL = "/player/store/orders/express-charge";
    private static String GET_ALL_PRODUCTS_URL = "/player/store/items/slug";
    private static String GET_PURCHASE_URL = "/player/store/purchase/histories";
    private static String CONSUME_URL = "/player/store/purchase/consume";

    private UdpSandboxRestClient() {
        POST_TOKEN_URL = "https://api-udp.unity.com" + API_VERSION + POST_TOKEN_URL;
        PURCHASE_URL = "https://api-udp.unity.com" + API_VERSION + PURCHASE_URL;
        GET_ALL_PRODUCTS_URL = "https://api-udp.unity.com" + API_VERSION + GET_ALL_PRODUCTS_URL;
        GET_PURCHASE_URL = "https://api-udp.unity.com" + API_VERSION + GET_PURCHASE_URL;
        CONSUME_URL = "https://api-udp.unity.com" + API_VERSION + CONSUME_URL;
    }

    public static UdpSandboxRestClient getInstance() {
        if (instance == null) {
            instance = new UdpSandboxRestClient();
        }
        return instance;
    }

    public PostTokenResponse postToken(PostTokenRequest request) throws RuntimeException {
        RestResponse restResponse = this.execute(HttpMethod.POST, POST_TOKEN_URL, request, null, null, PostTokenResponse.class, "application/x-www-form-urlencoded; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (PostTokenResponse)((Object)restResponse.getEntity());
    }

    public PurchaseResponse purchase(PurchaseRequest request, Map<String, String> queryParam) {
        RestResponse restResponse = this.execute(HttpMethod.POST, PURCHASE_URL, request, null, queryParam, PurchaseResponse.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (PurchaseResponse)((Object)restResponse.getEntity());
    }

    public GetAllProductsResponse getAllProducts(String appItemSlug, Map<String, String> queryParam) {
        String url = String.format("%s/%s/iap", GET_ALL_PRODUCTS_URL, appItemSlug);
        RestResponse restResponse = this.execute(HttpMethod.GET, url, null, null, queryParam, GetAllProductsResponse.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (GetAllProductsResponse)((Object)restResponse.getEntity());
    }

    public void consume(ConsumeRequest request, Map<String, String> queryParam) {
        RestResponse restResponse = this.execute(HttpMethod.POST, CONSUME_URL, request, null, queryParam, null, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
    }

    public GetPurchaseResponse getPurchase(GetPurchaseRequest request, String access_token) {
        Map queryParam = request.toMap();
        queryParam.put("token", access_token);
        RestResponse restResponse = this.execute(HttpMethod.GET, GET_PURCHASE_URL, null, null, queryParam, GetPurchaseResponse.class, "application/json; charset=UTF-8");
        this.checkErrorAndThrow(restResponse);
        return (GetPurchaseResponse)((Object)restResponse.getEntity());
    }
}

