/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.common.rest;

import com.unity.udp.sdk.common.ClassMap;
import com.unity.udp.sdk.common.Logger;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseModel {
    private Map<String, Object> others = new HashMap<String, Object>();

    public static BaseModel fromJsonObject(Class<?> clazz, JSONObject object) {
        BaseModel model = null;
        try {
            Field[] fields;
            model = (BaseModel)clazz.newInstance();
            for (Field field : fields = model.getClass().getDeclaredFields()) {
                JSONArray jsonArray;
                Object value;
                field.setAccessible(true);
                if (!object.has(field.getName()) || (value = object.get(field.getName())).toString().equals("null")) continue;
                Class fieldType = field.getType();
                if (fieldType.isPrimitive()) {
                    fieldType = ClassMap.wrapperClass(fieldType);
                }
                if (BaseModel.isBasicClass(fieldType)) {
                    try {
                        if (fieldType.equals(String.class)) {
                            field.set(model, value.toString());
                            continue;
                        }
                        Method valueOf = fieldType.getMethod("valueOf", String.class);
                        field.set(model, valueOf.invoke(null, value.toString()));
                    }
                    catch (NoSuchMethodException e) {
                        Logger.logError("JSON parsing failed. Cannot find valueOf method on " + fieldType.getName());
                    }
                    catch (InvocationTargetException e) {
                        Logger.logError("Invocation of valueOf failed: " + e.getMessage());
                    }
                    continue;
                }
                if (fieldType.isArray()) {
                    jsonArray = (JSONArray)value;
                    Object array = BaseModel.fromJsonArray(jsonArray, fieldType);
                    field.set(model, array);
                    continue;
                }
                if (BaseModel.isCollection(fieldType)) {
                    jsonArray = (JSONArray)value;
                    Collection collection = BaseModel.fromJsonArray2Collection(jsonArray, fieldType);
                    field.set(model, collection);
                    continue;
                }
                if (BaseModel.isSubClassOfBaseModel(fieldType)) {
                    if (value instanceof JSONObject) {
                        field.set(model, BaseModel.fromJsonObject(fieldType, (JSONObject)value));
                        continue;
                    }
                    field.set(model, BaseModel.fromJsonObject(field.getType(), new JSONObject(value.toString())));
                    continue;
                }
                Logger.logWarn(String.format("Field (%s) cannot be converted", field.getName()));
            }
        }
        catch (IllegalAccessException e) {
            Logger.logError("IllegalAccessException: " + e.getMessage());
        }
        catch (InstantiationException e) {
            Logger.logError("InstantiationException: " + e.getMessage());
        }
        catch (JSONException e) {
            Logger.logError("JSONException: " + e.getMessage());
        }
        catch (NullPointerException e) {
            Logger.logWarn("NullPointerException: " + e.getMessage());
        }
        return model;
    }

    private static Object fromJsonArray(JSONArray jsonArray, Class<?> fieldType) throws JSONException {
        int length = jsonArray.length();
        Class<?> componentType = fieldType.getComponentType();
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            JSONArray subJsonArray;
            if (BaseModel.isBasicClass(componentType)) {
                Array.set(array, i, jsonArray.get(i));
                continue;
            }
            if (BaseModel.isArray(componentType)) {
                subJsonArray = jsonArray.getJSONArray(i);
                Array.set(array, i, BaseModel.fromJsonArray(subJsonArray, componentType));
                continue;
            }
            if (BaseModel.isCollection(componentType)) {
                subJsonArray = jsonArray.getJSONArray(i);
                Array.set(array, i, BaseModel.fromJsonArray2Collection(subJsonArray, componentType));
                continue;
            }
            if (BaseModel.isSubClassOfBaseModel(componentType)) {
                Array.set(array, i, BaseModel.fromJsonObject(componentType, jsonArray.getJSONObject(i)));
                continue;
            }
            Logger.logWarn(String.format("The array field has invalid component type (%s) that cannot be converted", componentType.getName()));
        }
        return array;
    }

    private static Collection fromJsonArray2Collection(JSONArray jsonArray, Class<?> fieldType) throws JSONException {
        Class<Object> instantiateClass = null;
        if (!fieldType.isInterface()) {
            instantiateClass = fieldType;
        } else if (List.class.isAssignableFrom(fieldType)) {
            Logger.logWarn("This is a List");
            instantiateClass = ArrayList.class;
        } else if (SortedSet.class.isAssignableFrom(fieldType)) {
            Logger.logWarn("This is a SortedSet");
            instantiateClass = TreeSet.class;
        } else if (Set.class.isAssignableFrom(fieldType)) {
            Logger.logWarn("This is a Set");
            instantiateClass = HashSet.class;
        } else {
            Logger.logError(String.format("The field of type %s is not supported", fieldType.getName()));
        }
        Collection collection = null;
        try {
            collection = (Collection)instantiateClass.newInstance();
        }
        catch (InstantiationException e) {
            Logger.logError(String.format("The field of type %s is not supported", fieldType.getName()));
        }
        catch (IllegalAccessException e) {
            Logger.logError("The collection field cannot be converted.");
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray subJsonArray;
            Object item = jsonArray.get(i);
            Class<?> componentType = item.getClass();
            if (BaseModel.isBasicClass(componentType)) {
                collection.add(item);
                continue;
            }
            if (BaseModel.isArray(componentType)) {
                subJsonArray = (JSONArray)item;
                collection.add(BaseModel.fromJsonArray(subJsonArray, componentType));
                continue;
            }
            if (BaseModel.isCollection(componentType)) {
                subJsonArray = (JSONArray)item;
                collection.add(BaseModel.fromJsonArray2Collection(subJsonArray, componentType));
                continue;
            }
            if (BaseModel.isSubClassOfBaseModel(componentType)) {
                JSONObject jsonObject = (JSONObject)item;
                collection.add(BaseModel.fromJsonObject(componentType, jsonObject));
                continue;
            }
            Logger.logWarn(String.format("The collection field has invalid component type (%s) that cannot be converted", componentType.getName()));
            break;
        }
        return collection;
    }

    private static boolean isBasicClass(Class<?> clazz) {
        return clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(String.class) || clazz.equals(Short.class) || clazz.equals(Long.class) || clazz.equals(Boolean.class) || clazz.equals(Float.class) || clazz.isPrimitive();
    }

    private static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    private static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private static boolean isSubClassOfBaseModel(Class<?> clazz) {
        return BaseModel.class.isAssignableFrom(clazz);
    }

    private static JSONArray toJsonArray(Object array, Class<?> fieldType) throws IllegalArgumentException {
        if (!fieldType.isArray()) {
            throw new IllegalArgumentException("The input argument is not an array.");
        }
        JSONArray jsonArray = new JSONArray();
        int length = Array.getLength(array);
        if (length == 0) {
            return jsonArray;
        }
        Class<?> componentType = fieldType.getComponentType();
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            if (BaseModel.isBasicClass(componentType)) {
                jsonArray.put(item);
                continue;
            }
            if (BaseModel.isArray(componentType)) {
                jsonArray.put((Object)BaseModel.toJsonArray(item, componentType));
                continue;
            }
            if (BaseModel.isCollection(componentType)) {
                Collection subCollection = (Collection)item;
                jsonArray.put((Object)BaseModel.toJsonArray(subCollection));
                continue;
            }
            if (BaseModel.isSubClassOfBaseModel(componentType)) {
                BaseModel baseModel = (BaseModel)item;
                jsonArray.put((Object)baseModel.toJsonObject());
                continue;
            }
            Logger.logWarn(String.format("The array field has invalid component type (%s) that cannot be converted", componentType.getName()));
            break;
        }
        return jsonArray;
    }

    private static JSONArray toJsonArray(Collection collection) {
        JSONArray jsonArray = new JSONArray();
        if (collection.isEmpty()) {
            return jsonArray;
        }
        for (Object item : collection) {
            Class<?> componentType = item.getClass();
            if (BaseModel.isBasicClass(componentType)) {
                jsonArray.put(item);
                continue;
            }
            if (BaseModel.isArray(componentType)) {
                jsonArray.put((Object)BaseModel.toJsonArray(item, componentType));
                continue;
            }
            if (BaseModel.isCollection(componentType)) {
                Collection subCollection = (Collection)item;
                jsonArray.put((Object)BaseModel.toJsonArray(subCollection));
                continue;
            }
            if (BaseModel.isSubClassOfBaseModel(componentType)) {
                BaseModel baseModel = (BaseModel)item;
                jsonArray.put((Object)baseModel.toJsonObject());
                continue;
            }
            Logger.logWarn(String.format("The collection field has invalid component type (%s) that cannot be converted", componentType.getName()));
            break;
        }
        return jsonArray;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        try {
            Field[] fields;
            for (Field field : fields = this.getClass().getDeclaredFields()) {
                JSONArray jsonArray;
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                if (BaseModel.isBasicClass(fieldType)) {
                    object.put(field.getName(), field.get(this));
                    continue;
                }
                if (BaseModel.isArray(fieldType)) {
                    Object array = field.get(this);
                    jsonArray = BaseModel.toJsonArray(array, fieldType);
                    object.put(field.getName(), (Object)jsonArray);
                    continue;
                }
                if (BaseModel.isCollection(fieldType)) {
                    Collection collection = (Collection)field.get(this);
                    jsonArray = BaseModel.toJsonArray(collection);
                    object.put(field.getName(), (Object)jsonArray);
                    continue;
                }
                if (BaseModel.isSubClassOfBaseModel(fieldType)) {
                    object.put(field.getName(), (Object)((BaseModel)field.get(this)).toJsonObject());
                    continue;
                }
                Logger.logWarn(String.format("Field (%s) cannot be converted", field.getName()));
            }
        }
        catch (IllegalAccessException e) {
            Logger.logError("IllegalAccessException: " + e.getMessage());
        }
        catch (JSONException e) {
            Logger.logError("JSONException: " + e.getMessage());
        }
        return object;
    }

    public String toFormString() {
        StringBuilder sb = new StringBuilder();
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.get(this) == null) continue;
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(field.getName());
                sb.append("=");
                sb.append(URLEncoder.encode((String)field.get(this), "UTF-8"));
                ++i;
            }
        }
        catch (IllegalAccessException ex) {
            Logger.logError("IllegalAccessException: " + ex.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError("Encoding isn't supported.");
        }
        return sb.toString();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Field[] fields;
            for (Field field : fields = this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(this) == null) continue;
                map.put(field.getName(), String.valueOf(field.get(this)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public String toString() {
        return this.toJsonObject().toString();
    }
}

