/*
 * Decompiled with CFR 0.152.
 */
package com.cm.androidforunity;

import android.content.Context;
import android.os.AsyncTask;
import com.cm.androidforunity.SdkHttpListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SdkHttpTask
extends AsyncTask<String, Void, String> {
    private static final String TAG = "SdkHttpTask";
    private static final int MAX_RETRY_TIME = 3;
    private static final int CONN_TIMEOUT = 15000;
    private static final int SO_TIMEOUT = 20000;
    private int mRetryCount;
    private SdkHttpListener mListener;
    private ArrayList<NameValuePair> mKeyValueArray;
    private boolean mIsHttpPost;
    private Context mContext;

    public SdkHttpTask(Context context) {
        this.mContext = context;
    }

    public void doPost(ArrayList<NameValuePair> keyValueArray, String url, SdkHttpListener listener) {
        this.mListener = listener;
        this.mIsHttpPost = true;
        this.mKeyValueArray = keyValueArray;
        this.mRetryCount = 0;
        this.execute(new String[]{url});
    }

    public void doGet(SdkHttpListener listener, String url) {
        this.mListener = listener;
        this.mIsHttpPost = false;
        this.mRetryCount = 0;
        this.execute(new String[]{url});
    }

    protected String doInBackground(String ... params) {
        String response = null;
        while (response == null && this.mRetryCount < 3) {
            if (this.isCancelled()) {
                return null;
            }
            try {
                String uri = params[0];
                HttpResponse httpResp = this.executeHttp(this.mContext, uri);
                if (httpResp != null && !this.isCancelled()) {
                    InputStream content;
                    int st = httpResp.getStatusLine().getStatusCode();
                    HttpEntity entity = httpResp.getEntity();
                    if (entity != null && (content = entity.getContent()) != null) {
                        response = SdkHttpTask.convertStreamToString(content);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++this.mRetryCount;
        }
        return response;
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.mListener != null) {
            this.mListener.onCancelled();
            this.mListener = null;
        }
    }

    protected void onPostExecute(String response) {
        super.onPostExecute((Object)response);
        if (this.mListener != null && !this.isCancelled()) {
            this.mListener.onResponse(response);
            this.mListener = null;
        }
    }

    private HttpResponse executeHttp(Context context, String uri) throws SSLHandshakeException, ClientProtocolException, IOException {
        return this.mIsHttpPost ? SdkHttpTask.post(context, uri, this.mKeyValueArray) : SdkHttpTask.get(context, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private static HttpResponse post(Context context, String url, ArrayList<NameValuePair> params) throws SSLHandshakeException, ClientProtocolException, IOException {
        boolean isParam = params != null;
        url = url.replaceAll(" ", "%20");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)15000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setHeader("Charset", "UTF-8");
        if (isParam) {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        return httpClient.execute((HttpUriRequest)post);
    }

    private static HttpResponse get(Context context, String url) throws SSLHandshakeException, ClientProtocolException, IOException {
        url = url.replaceAll(" ", "%20");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)15000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        HttpGet get = new HttpGet(url);
        get.setHeader("Content-Type", "application/x-www-form-urlencoded");
        get.setHeader("Charset", "UTF-8");
        return httpClient.execute((HttpUriRequest)get);
    }
}

