/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.googleplay;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.unity.purchasing.googleplay.BillingServiceProcessor;
import com.unity.purchasing.googleplay.GooglePlayBillingUnAvailableException;
import com.unity.purchasing.googleplay.IBillingServiceManager;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BillingServiceManager
implements IBillingServiceManager {
    private volatile IInAppBillingService mService;
    private volatile ServiceConnection mServiceConn;
    private Context context;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Intent googlePlayBillingServiceIntent;
    private final ConcurrentLinkedQueue<BillingServiceProcessor> callbacks = new ConcurrentLinkedQueue();
    private boolean mIsBound = false;

    public BillingServiceManager(final Context context) {
        this.context = context;
        if (context == null) {
            this.logDebug("Unable to create BillingService Instance, invalid context");
        }
        this.mServiceConn = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                BillingServiceManager.this.logDebug("Billing service disconnected.");
                BillingServiceManager.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (context != null && BillingServiceManager.this.mIsBound) {
                            context.unbindService(BillingServiceManager.this.mServiceConn);
                            BillingServiceManager.this.mIsBound = false;
                        }
                        BillingServiceManager.this.mService = null;
                        if (BillingServiceManager.this.callbacks.size() == 0) {
                            BillingServiceManager.this.logDebug("Releasing billing service.");
                        } else {
                            BillingServiceManager.this.logDebug("Rebinding billing service.");
                            BillingServiceManager.this.bindToGooglePlayService();
                        }
                    }
                });
            }

            public void onServiceConnected(ComponentName name, final IBinder service) {
                BillingServiceManager.this.logDebug("Billing service connected.");
                BillingServiceManager.this.mIsBound = true;
                BillingServiceManager.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        BillingServiceManager.this.mService = IInAppBillingService.Stub.asInterface((IBinder)service);
                        BillingServiceManager.this.tryPumpCallbacks();
                    }
                });
            }
        };
    }

    @Override
    public void initialise() throws GooglePlayBillingUnAvailableException {
        if (null == this.googlePlayBillingServiceIntent) {
            this.googlePlayBillingServiceIntent = this.getGooglePlayServiceIntent();
        }
    }

    private Intent getGooglePlayServiceIntent() throws GooglePlayBillingUnAvailableException {
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List list = this.context.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (null != list && list.size() == 1) {
            return serviceIntent;
        }
        String message = "Expected to find a single Google Play billing service but found " + (null == list ? "0" : Integer.valueOf(list.size()));
        this.logDebug(message);
        throw new GooglePlayBillingUnAvailableException(message);
    }

    void bindToGooglePlayService() {
        this.context.bindService(this.googlePlayBillingServiceIntent, this.mServiceConn, 1);
    }

    public boolean billingAvailable() {
        return false;
    }

    @Override
    public void workWith(BillingServiceProcessor processor) {
        this.callbacks.add(processor);
        this.tryPumpCallbacks();
    }

    @Override
    public void dispose() {
        if (this.context != null && this.mIsBound) {
            this.context.unbindService(this.mServiceConn);
            this.mIsBound = false;
        }
    }

    private void tryPumpCallbacks() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (BillingServiceManager.this.mService != null) {
                    while (BillingServiceManager.this.callbacks.size() > 0) {
                        BillingServiceManager.this.logDebug("invoking callback");
                        ((BillingServiceProcessor)BillingServiceManager.this.callbacks.remove()).workWith(BillingServiceManager.this.mService);
                    }
                } else {
                    BillingServiceManager.this.bindToGooglePlayService();
                }
            }
        });
    }

    private void logDebug(String msg) {
        Log.i((String)"UnityIAP", (String)msg);
    }
}

