/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.googleplay;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.google.vr.ndk.base.DaydreamApi;
import com.unity.purchasing.common.SaneJSONObject;
import com.unity.purchasing.googleplay.BillingServiceProcessor;
import com.unity.purchasing.googleplay.IActivityLauncher;
import com.unity.purchasing.googleplay.IBillingServiceManager;
import com.unity.purchasing.googleplay.IabException;
import com.unity.purchasing.googleplay.IabResult;
import com.unity.purchasing.googleplay.Inventory;
import com.unity.purchasing.googleplay.Purchase;
import com.unity.purchasing.googleplay.SkuDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class IabHelper {
    boolean mDebugLog = false;
    String mDebugTag = "IabHelper";
    volatile boolean mSetupDone = false;
    volatile boolean mDisposed = false;
    boolean mSubscriptionsSupported = false;
    boolean mSubscriptionUpgradeDowngradeSupported = false;
    boolean mSubscriptionPurchaseHistorySupported = false;
    private boolean mVrSupported = false;
    private boolean mUnityVrEnabled = false;
    private boolean mDaydreamApiAvailable = false;
    String mAsyncOperation = "";
    Context mContext;
    private IBillingServiceManager serviceManager;
    private IActivityLauncher launcher;
    int mRequestCode;
    String mPurchasingItemType;
    private Inventory inv;
    private static final int IN_APP_BILLING_API_VERSION_6 = 6;
    private static final int IN_APP_BILLING_API_VERSION_7 = 7;
    private static final int IN_APP_BILLING_API_VERSION_3 = 3;
    private static final int IN_APP_BILLING_API_VERSION_5 = 5;
    public static final int BILLING_RESPONSE_RESULT_OK = 0;
    public static final int BILLING_RESPONSE_RESULT_USER_CANCELED = 1;
    public static final int BILLING_RESPONSE_RESULT_SERVICE_UNAVAILABLE = 2;
    public static final int BILLING_RESPONSE_RESULT_BILLING_UNAVAILABLE = 3;
    public static final int BILLING_RESPONSE_RESULT_ITEM_UNAVAILABLE = 4;
    public static final int BILLING_RESPONSE_RESULT_DEVELOPER_ERROR = 5;
    public static final int BILLING_RESPONSE_RESULT_ERROR = 6;
    public static final int BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED = 7;
    public static final int BILLING_RESPONSE_RESULT_ITEM_NOT_OWNED = 8;
    public static final int IABHELPER_ERROR_BASE = -1000;
    public static final int IABHELPER_REMOTE_EXCEPTION = -1001;
    public static final int IABHELPER_BAD_RESPONSE = -1002;
    public static final int IABHELPER_VERIFICATION_FAILED = -1003;
    public static final int IABHELPER_SEND_INTENT_FAILED = -1004;
    public static final int IABHELPER_USER_CANCELLED = -1005;
    public static final int IABHELPER_UNKNOWN_PURCHASE_RESPONSE = -1006;
    public static final int IABHELPER_MISSING_TOKEN = -1007;
    public static final int IABHELPER_UNKNOWN_ERROR = -1008;
    public static final int IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE = -1009;
    public static final int IABHELPER_INVALID_CONSUMPTION = -1010;
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
    public static final String RESPONSE_BUY_INTENT = "BUY_INTENT";
    public static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    public static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    public static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    public static final String ITEM_TYPE_INAPP = "inapp";
    public static final String ITEM_TYPE_SUBS = "subs";
    public static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    public static final String GET_SKU_DETAILS_ITEM_TYPE_LIST = "ITEM_TYPE_LIST";
    public static HashMap<Integer, String> billingResponseCodeNames = new HashMap();
    OnIabPurchaseFinishedListener mPurchaseListener;

    public IabHelper(Context ctx, IBillingServiceManager manager, IActivityLauncher launcher) {
        this.mContext = ctx.getApplicationContext();
        this.serviceManager = manager;
        this.launcher = launcher;
        this.inv = new Inventory();
        this.logDebug("IAB helper created.");
    }

    public void enableDebugLogging(boolean enable, String tag) {
        this.mDebugLog = enable;
        this.mDebugTag = tag;
    }

    public void enableDebugLogging(boolean enable) {
        this.mDebugLog = enable;
    }

    public void enableUnityVr(boolean enabled) {
        this.mUnityVrEnabled = enabled;
    }

    public void enableDaydreamApi(boolean enabled) {
        this.mDaydreamApiAvailable = enabled;
    }

    public void startSetup(final OnIabSetupFinishedListener listener) {
        if (this.mSetupDone) {
            throw new IllegalStateException("IAB helper is already set up.");
        }
        this.logDebug("Starting in-app billing setup.");
        this.serviceManager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                IabHelper.this.finishSetup(listener, service);
            }
        });
    }

    private void finishSetup(OnIabSetupFinishedListener listener, IInAppBillingService service) {
        String packageName = this.mContext.getPackageName();
        try {
            this.logDebug("Checking for in-app billing 3 support.");
            int response = service.isBillingSupported(3, packageName, ITEM_TYPE_INAPP);
            if (response != 0) {
                listener.onIabSetupFinished(new IabResult(response, "Billing V3 not supported."));
                this.mSubscriptionsSupported = false;
                return;
            }
            this.logDebug("In-app billing version 3 supported for " + packageName);
            response = service.isBillingSupported(3, packageName, ITEM_TYPE_SUBS);
            if (response == 0) {
                this.logDebug("Subscriptions AVAILABLE.");
                this.mSubscriptionsSupported = true;
                int response_v5 = service.isBillingSupported(5, packageName, ITEM_TYPE_SUBS);
                if (response_v5 == 0) {
                    this.mSubscriptionUpgradeDowngradeSupported = true;
                    this.logDebug("Subscription upgrade and downgrade are AVAILABLE.");
                } else {
                    this.logDebug("Subscription upgrade and downgrade are NOT AVAILABLE.");
                }
                int response_v6 = service.isBillingSupported(6, packageName, ITEM_TYPE_SUBS);
                if (response_v6 == 0) {
                    this.mSubscriptionPurchaseHistorySupported = true;
                    this.logDebug("Subscriptions information parse AVAILABLE.");
                } else {
                    this.logDebug("Subscriptions information parse NOT AVAILABLE.");
                }
            } else {
                this.logDebug("Subscriptions NOT AVAILABLE. Response: " + response);
            }
            int response_v7 = service.isBillingSupported(7, packageName, ITEM_TYPE_INAPP);
            if (response_v7 == 0) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("vr", true);
                response = service.isBillingSupportedExtraParams(7, this.mContext.getPackageName(), ITEM_TYPE_INAPP, bundle);
                if (response == 0) {
                    this.logDebug("VR supported.");
                    this.mVrSupported = true;
                } else {
                    this.logDebug("VR purchases  NOT AVAILABLE. Response: " + response);
                }
            } else {
                this.logDebug("In app billing version 7 is not supported");
            }
            this.mSetupDone = true;
        }
        catch (RemoteException e) {
            listener.onIabSetupFinished(new IabResult(-1001, "RemoteException while setting up in-app billing."));
            return;
        }
        listener.onIabSetupFinished(new IabResult(0, "Setup successful."));
    }

    public void dispose() {
        this.logDebug("Disposing.");
        this.mSetupDone = false;
        this.serviceManager.dispose();
        this.mDisposed = true;
    }

    public boolean subscriptionsSupported() {
        return this.mSubscriptionsSupported;
    }

    public boolean subscriptionPurchaseHistorySupported() {
        return this.mSubscriptionPurchaseHistorySupported;
    }

    public boolean subscriptionUpgradeDowngradeSupported() {
        return this.mSubscriptionUpgradeDowngradeSupported;
    }

    public void launchPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        this.launchPurchaseFlow(act, sku, requestCode, listener, "");
    }

    public void launchPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(act, sku, ITEM_TYPE_INAPP, requestCode, listener, extraData);
    }

    public void launchSubscriptionPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        this.launchSubscriptionPurchaseFlow(act, sku, requestCode, listener, "");
    }

    public void launchSubscriptionPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(act, sku, ITEM_TYPE_SUBS, requestCode, listener, extraData);
    }

    public void launchSubscriptionUpdateFlow(final Activity act, final String sku, final List<String> oldSkus, final int requestCode, final OnIabPurchaseFinishedListener listener, final String extraData) {
        this.checkSetupDone("launchSubscriptionUpdateFlow");
        if (!this.mSubscriptionsSupported || !this.mSubscriptionUpgradeDowngradeSupported) {
            IabResult r = new IabResult(-1009, "Subscription upgrade/downgrade is not available.");
            if (listener != null) {
                listener.onIabPurchaseFinished(r, null);
            }
            return;
        }
        this.serviceManager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                block14: {
                    try {
                        IabHelper.this.logDebug("Constructing buy intent for " + sku + ", item type: " + IabHelper.ITEM_TYPE_SUBS);
                        Bundle buyIntentBundle = null;
                        String accountId = IabHelper.this.getAccountId(extraData);
                        if (IabHelper.this.mVrSupported) {
                            Bundle bundle = new Bundle();
                            if (IabHelper.this.mUnityVrEnabled) {
                                bundle.putBoolean("vr", true);
                                IabHelper.this.logDebug("Initiating VR purchase intent");
                            }
                            if (accountId != null) {
                                bundle.putString("accountId", accountId);
                                IabHelper.this.logDebug("pass accountId to GooglePlay for fraud detection " + accountId);
                            }
                            bundle.putStringArrayList("skusToReplace", new ArrayList(oldSkus));
                            bundle.putBoolean("replaceSkusProration", true);
                            buyIntentBundle = service.getBuyIntentExtraParams(7, IabHelper.this.mContext.getPackageName(), sku, IabHelper.ITEM_TYPE_SUBS, extraData, bundle);
                        } else {
                            buyIntentBundle = service.getBuyIntentToReplaceSkus(5, IabHelper.this.mContext.getPackageName(), oldSkus, sku, IabHelper.ITEM_TYPE_SUBS, extraData);
                        }
                        int response = IabHelper.this.getResponseCodeFromBundle(buyIntentBundle);
                        if (response != 0) {
                            IabHelper.this.logError("Unable to update subscription, Error response: " + IabHelper.getResponseDesc(response));
                            IabResult result = new IabResult(response, "Unable to update subscription item");
                            SaneJSONObject o = new SaneJSONObject();
                            o.put("productId", (Object)sku);
                            try {
                                Purchase purchase = response == 7 && IabHelper.this.inv.hasPurchase(sku) ? IabHelper.this.inv.getPurchase(sku) : new Purchase(IabHelper.ITEM_TYPE_SUBS, o.toString(), "");
                                act.finish();
                                if (listener != null) {
                                    listener.onIabPurchaseFinished(result, purchase);
                                }
                                return;
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                        final PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable(IabHelper.RESPONSE_BUY_INTENT);
                        IabHelper.this.logDebug("Launching buy intent for " + sku + ". Request code: " + requestCode);
                        IabHelper.this.mRequestCode = requestCode;
                        IabHelper.this.mPurchaseListener = listener;
                        IabHelper.this.mPurchasingItemType = IabHelper.ITEM_TYPE_SUBS;
                        if (IabHelper.this.mVrSupported && IabHelper.this.mUnityVrEnabled && IabHelper.this.mDaydreamApiAvailable) {
                            Runnable task = new Runnable(){

                                @Override
                                public void run() {
                                    DaydreamApi api = DaydreamApi.create((Context)act);
                                    api.launchInVrForResult(act, pendingIntent, requestCode);
                                    api.close();
                                }
                            };
                            new Handler(Looper.getMainLooper()).post(task);
                        } else {
                            IntentSender sender = pendingIntent.getIntentSender();
                            IabHelper.this.launcher.startIntentSenderForResult(act, pendingIntent, requestCode, new Intent(), sku);
                        }
                    }
                    catch (IntentSender.SendIntentException e) {
                        IabHelper.this.logError("SendIntentException while launching purchase flow for sku " + sku);
                        e.printStackTrace();
                        IabResult result = new IabResult(-1004, "Failed to send intent.");
                        if (listener != null) {
                            listener.onIabPurchaseFinished(result, null);
                        }
                    }
                    catch (RemoteException e) {
                        IabHelper.this.logError("RemoteException while launching purchase flow for sku " + sku);
                        e.printStackTrace();
                        IabResult result = new IabResult(-1001, "Remote exception while starting purchase flow");
                        if (listener == null) break block14;
                        listener.onIabPurchaseFinished(result, null);
                    }
                }
            }
        });
    }

    public void launchPurchaseFlow(final Activity act, final String sku, final String itemType, final int requestCode, final OnIabPurchaseFinishedListener listener, final String extraData) {
        this.checkSetupDone("launchPurchaseFlow");
        if (itemType.equals(ITEM_TYPE_SUBS) && !this.mSubscriptionsSupported) {
            IabResult r = new IabResult(-1009, "Subscriptions are not available.");
            if (listener != null) {
                listener.onIabPurchaseFinished(r, null);
            }
            return;
        }
        this.serviceManager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                block14: {
                    try {
                        IabHelper.this.logDebug("Constructing buy intent for " + sku + ", item type: " + itemType);
                        Bundle buyIntentBundle = null;
                        String accountId = IabHelper.this.getAccountId(extraData);
                        if (IabHelper.this.mVrSupported) {
                            Bundle bundle = new Bundle();
                            if (IabHelper.this.mUnityVrEnabled) {
                                bundle.putBoolean("vr", true);
                                IabHelper.this.logDebug("Initiating VR purchase intent");
                            }
                            if (accountId != null) {
                                bundle.putString("accountId", accountId);
                                IabHelper.this.logDebug("pass accountId to GooglePlay for fraud detection, and accountId is: " + accountId);
                            }
                            buyIntentBundle = service.getBuyIntentExtraParams(7, IabHelper.this.mContext.getPackageName(), sku, itemType, extraData, bundle);
                        } else {
                            buyIntentBundle = service.getBuyIntent(3, IabHelper.this.mContext.getPackageName(), sku, itemType, extraData);
                        }
                        int response = IabHelper.this.getResponseCodeFromBundle(buyIntentBundle);
                        if (response != 0) {
                            IabHelper.this.logError("Unable to buy item, Error response: " + IabHelper.getResponseDesc(response));
                            IabResult result = new IabResult(response, "Unable to buy item");
                            SaneJSONObject o = new SaneJSONObject();
                            o.put("productId", (Object)sku);
                            try {
                                Purchase purchase = response == 7 && IabHelper.this.inv.hasPurchase(sku) ? IabHelper.this.inv.getPurchase(sku) : new Purchase(itemType, o.toString(), "");
                                act.finish();
                                if (listener != null) {
                                    listener.onIabPurchaseFinished(result, purchase);
                                }
                                return;
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                        final PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable(IabHelper.RESPONSE_BUY_INTENT);
                        IabHelper.this.logDebug("Launching buy intent for " + sku + ". Request code: " + requestCode);
                        IabHelper.this.mRequestCode = requestCode;
                        IabHelper.this.mPurchaseListener = listener;
                        IabHelper.this.mPurchasingItemType = itemType;
                        if (IabHelper.this.mVrSupported && IabHelper.this.mUnityVrEnabled && IabHelper.this.mDaydreamApiAvailable) {
                            Runnable task = new Runnable(){

                                @Override
                                public void run() {
                                    DaydreamApi api = DaydreamApi.create((Context)act);
                                    api.launchInVrForResult(act, pendingIntent, requestCode);
                                    api.close();
                                }
                            };
                            new Handler(Looper.getMainLooper()).post(task);
                        } else {
                            IntentSender sender = pendingIntent.getIntentSender();
                            IabHelper.this.launcher.startIntentSenderForResult(act, pendingIntent, requestCode, new Intent(), sku);
                        }
                    }
                    catch (IntentSender.SendIntentException e) {
                        IabHelper.this.logError("SendIntentException while launching purchase flow for sku " + sku);
                        e.printStackTrace();
                        IabResult result = new IabResult(-1004, "Failed to send intent.");
                        if (listener != null) {
                            listener.onIabPurchaseFinished(result, null);
                        }
                    }
                    catch (RemoteException e) {
                        IabHelper.this.logError("RemoteException while launching purchase flow for sku " + sku);
                        e.printStackTrace();
                        IabResult result = new IabResult(-1001, "Remote exception while starting purchase flow");
                        if (listener == null) break block14;
                        listener.onIabPurchaseFinished(result, null);
                    }
                }
            }
        });
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != this.mRequestCode) {
            return false;
        }
        this.checkSetupDone("handleActivityResult");
        if (data == null) {
            this.logError("Null data in IAB activity result.");
            IabResult result = new IabResult(-1002, "Null data in IAB result");
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
            return true;
        }
        int responseCode = this.getResponseCodeFromIntent(data);
        String purchaseData = data.getStringExtra(RESPONSE_INAPP_PURCHASE_DATA);
        String dataSignature = data.getStringExtra(RESPONSE_INAPP_SIGNATURE);
        this.logDebug("Purchase data: " + purchaseData);
        this.logDebug("Data signature: " + dataSignature);
        if (resultCode == -1 && responseCode == 0) {
            this.logDebug("Successful resultcode from purchase activity.");
            this.logDebug("Purchase data: " + purchaseData);
            this.logDebug("Data signature: " + dataSignature);
            this.logDebug("Extras: " + data.getExtras());
            this.logDebug("Expected item type: " + this.mPurchasingItemType);
            if (purchaseData == null || dataSignature == null) {
                this.logError("BUG: either purchaseData or dataSignature is null.");
                this.logDebug("Extras: " + data.getExtras().toString());
                IabResult result = new IabResult(-1008, "IAB returned null purchaseData or dataSignature");
                if (this.mPurchaseListener != null) {
                    this.mPurchaseListener.onIabPurchaseFinished(result, null);
                }
                return true;
            }
            Purchase purchase = null;
            try {
                purchase = new Purchase(this.mPurchasingItemType, purchaseData, dataSignature);
                String string = purchase.getSku();
            }
            catch (JSONException e) {
                this.logError("Failed to parse purchase data.");
                e.printStackTrace();
                IabResult result = new IabResult(-1002, "Failed to parse purchase data.");
                if (this.mPurchaseListener != null) {
                    this.mPurchaseListener.onIabPurchaseFinished(result, null);
                }
                return true;
            }
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(new IabResult(0, "Success"), purchase);
            }
        } else if (resultCode == -1) {
            this.logDebug("Result code was OK but in-app billing response was not OK: " + IabHelper.getResponseDesc(responseCode));
            if (this.mPurchaseListener != null) {
                IabResult result = new IabResult(responseCode, "Problem purchasing item.");
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        } else if (resultCode == 0) {
            this.logDebug("Purchase canceled - Response: " + IabHelper.getResponseDesc(responseCode));
            IabResult result = new IabResult(responseCode, IabHelper.getResponseDesc(responseCode));
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        } else {
            this.logError("Purchase failed. Result code: " + Integer.toString(resultCode) + ". Response: " + IabHelper.getResponseDesc(responseCode));
            IabResult result = new IabResult(-1006, "Unknown purchase response.");
            if (this.mPurchaseListener != null) {
                this.mPurchaseListener.onIabPurchaseFinished(result, null);
            }
        }
        return true;
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreSkus, IInAppBillingService service) throws IabException {
        return this.queryInventory(querySkuDetails, moreSkus, null, service);
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreItemSkus, List<String> moreSubsSkus, IInAppBillingService service) throws IabException {
        this.checkSetupDone("queryInventory");
        try {
            int r = this.queryPurchases(this.inv, ITEM_TYPE_INAPP, service);
            if (r != 0) {
                throw new IabException(r, "Error refreshing inventory (querying owned items).");
            }
            if (querySkuDetails && (r = this.querySkuDetails(ITEM_TYPE_INAPP, this.inv, moreItemSkus, service)) != 0) {
                throw new IabException(r, "Error refreshing inventory (querying prices of items).");
            }
            if (this.mSubscriptionsSupported) {
                r = this.queryPurchases(this.inv, ITEM_TYPE_SUBS, service);
                if (r != 0) {
                    throw new IabException(r, "Error refreshing inventory (querying owned subscriptions).");
                }
                if (querySkuDetails && (r = this.querySkuDetails(ITEM_TYPE_SUBS, this.inv, moreItemSkus, service)) != 0) {
                    throw new IabException(r, "Error refreshing inventory (querying prices of subscriptions).");
                }
            }
            if (this.mSubscriptionPurchaseHistorySupported) {
                r = this.queryPurchaseHistory(this.inv, ITEM_TYPE_SUBS, service);
                r = this.queryPurchaseHistory(this.inv, ITEM_TYPE_INAPP, service);
                if (r != 0) {
                    throw new IabException(r, "Error query Purchase History");
                }
            }
            return this.inv;
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while refreshing inventory.", (Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new IabException(-1002, "Error parsing JSON response while refreshing inventory.", (Exception)((Object)e));
        }
        catch (SecurityException e) {
            throw new IabException(-1008, "SecurityException querying inventory, update Google Play - https://github.com/googlesamples/android-play-billing/issues/26", e);
        }
    }

    public void queryInventoryAsync(final boolean querySkuDetails, final List<String> moreSkus, final QueryInventoryFinishedListener listener, final long delay) {
        this.checkSetupDone("queryInventory");
        this.serviceManager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IabResult result = new IabResult(0, "Inventory refresh successful.");
                Inventory inv = null;
                try {
                    inv = IabHelper.this.queryInventory(querySkuDetails, moreSkus, service);
                }
                catch (IabException ex) {
                    result = ex.getResult();
                }
                IabResult result_f = result;
                Inventory inv_f = inv;
                if (!IabHelper.this.mDisposed && listener != null) {
                    try {
                        listener.onQueryInventoryFinished(result_f, inv_f);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void queryInventoryAsync(QueryInventoryFinishedListener listener) {
        this.queryInventoryAsync(true, null, listener, 0L);
    }

    public void queryInventoryAsync(boolean querySkuDetails, QueryInventoryFinishedListener listener) {
        this.queryInventoryAsync(querySkuDetails, null, listener, 0L);
    }

    void consume(Purchase itemInfo, IInAppBillingService service) throws IabException {
        if (!itemInfo.mItemType.equals(ITEM_TYPE_INAPP)) {
            throw new IabException(-1010, "Items of type '" + itemInfo.mItemType + "' can't be consumed.");
        }
        try {
            String token = itemInfo.getToken();
            String sku = itemInfo.getSku();
            if (token == null || token.equals("")) {
                this.logError("Can't consume " + sku + ". No token.");
                throw new IabException(-1007, "PurchaseInfo is missing token for sku: " + sku + " " + itemInfo);
            }
            this.logDebug("Consuming sku: " + sku + ", token: " + token);
            int response = service.consumePurchase(3, this.mContext.getPackageName(), token);
            if (response != 0) {
                this.logDebug("Error consuming consuming sku " + sku + ". " + IabHelper.getResponseDesc(response));
                throw new IabException(response, "Error consuming sku " + sku);
            }
            this.logDebug("Successfully consumed sku: " + sku);
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while consuming. PurchaseInfo: " + itemInfo, (Exception)((Object)e));
        }
    }

    void consumeSilently(Purchase itemInfo, IInAppBillingService service) throws IabException {
        if (!itemInfo.mItemType.equals(ITEM_TYPE_INAPP)) {
            return;
        }
        try {
            String token = itemInfo.getToken();
            String sku = itemInfo.getSku();
            if (token == null || token.equals("")) {
                return;
            }
            int n = service.consumePurchase(3, this.mContext.getPackageName(), token);
        }
        catch (RemoteException e) {
            return;
        }
    }

    public void consumeAsync(Purchase purchase, OnConsumeFinishedListener listener, boolean isSilent) {
        this.checkSetupDone("consume");
        ArrayList<Purchase> purchases = new ArrayList<Purchase>();
        purchases.add(purchase);
        this.consumeAsyncInternal(purchases, listener, null, isSilent);
    }

    public void consumeAsync(List<Purchase> purchases, OnConsumeMultiFinishedListener listener, boolean isSilent) {
        this.checkSetupDone("consume");
        this.consumeAsyncInternal(purchases, null, listener, isSilent);
    }

    public static String getResponseDesc(int code) {
        String[] iab_msgs = "0:OK/1:User Canceled/2:Unknown/3:Billing Unavailable/4:Item unavailable/5:Developer Error/6:Error/7:Item Already Owned/8:Item not owned".split("/");
        String[] iabhelper_msgs = "0:OK/-1001:Remote exception during initialization/-1002:Bad response received/-1003:Purchase signature verification failed/-1004:Send intent failed/-1005:User cancelled/-1006:Unknown purchase response/-1007:Missing token/-1008:Unknown error/-1009:Subscriptions not available/-1010:Invalid consumption attempt".split("/");
        if (code <= -1000) {
            int index = -1000 - code;
            if (index >= 0 && index < iabhelper_msgs.length) {
                return iabhelper_msgs[index];
            }
            return String.valueOf(code) + ":Unknown IAB Helper Error";
        }
        if (code < 0 || code >= iab_msgs.length) {
            return String.valueOf(code) + ":Unknown";
        }
        return iab_msgs[code];
    }

    void checkSetupDone(String operation) {
        if (!this.mSetupDone) {
            this.logError("Illegal state for operation (" + operation + "): IAB helper is not set up.");
            throw new IllegalStateException("IAB helper is not set up. Can't perform operation: " + operation);
        }
    }

    int getResponseCodeFromBundle(Bundle b) {
        if (b == null) {
            this.logDebug("null Bundle received from service, unknown cause and impact, returning error");
            return 6;
        }
        Object o = b.get(RESPONSE_CODE);
        if (o == null) {
            this.logDebug("Bundle with null response code, assuming OK (known issue)");
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        this.logError("Unexpected type for bundle response code.");
        this.logError(o.getClass().getName());
        throw new RuntimeException("Unexpected type for bundle response code: " + o.getClass().getName());
    }

    int getResponseCodeFromIntent(Intent i) {
        Object o = i.getExtras().get(RESPONSE_CODE);
        if (o == null) {
            this.logError("Intent with no response code, assuming OK (known issue)");
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        this.logError("Unexpected type for intent response code.");
        this.logError(o.getClass().getName());
        throw new RuntimeException("Unexpected type for intent response code: " + o.getClass().getName());
    }

    public int queryPurchaseHistory(Inventory inv, String itemType, IInAppBillingService service) throws JSONException, RemoteException {
        if (this.mDisposed) {
            this.logDebug("queryPurchase History - Biller disposed. Returning...");
            return 0;
        }
        this.logDebug("Querying owned items' purchase history, item type: " + itemType);
        this.logDebug("Package name: " + this.mContext.getPackageName());
        boolean verificationFailed = false;
        String continueToken = null;
        do {
            this.logDebug("Calling getPurchaseHistory with continuation token: " + continueToken);
            Bundle ownedItems = service.getPurchaseHistory(6, this.mContext.getPackageName(), itemType, continueToken, new Bundle());
            if (ownedItems == null) {
                return 0;
            }
            int response = this.getResponseCodeFromBundle(ownedItems);
            this.logDebug("Purchase history response: " + String.valueOf(response));
            if (response != 0) {
                this.logDebug("getPurchaseHistory() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            if (!(ownedItems.containsKey(RESPONSE_INAPP_ITEM_LIST) && ownedItems.containsKey(RESPONSE_INAPP_PURCHASE_DATA_LIST) && ownedItems.containsKey(RESPONSE_INAPP_SIGNATURE_LIST))) {
                this.logError("Bundle returned from getPurchaseHistory() doesn't contain required fields.");
                return -1002;
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
            if (itemType.equals(ITEM_TYPE_INAPP)) {
                ArrayList purchaseDataList = ownedItems.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
                ArrayList signatureList = ownedItems.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
                for (int i = 0; i < purchaseDataList.size(); ++i) {
                    String purchaseData = (String)purchaseDataList.get(i);
                    String signature = (String)signatureList.get(i);
                    String sku = (String)ownedSkus.get(i);
                    Purchase purchase = new Purchase(itemType, purchaseData, signature);
                    if (TextUtils.isEmpty((CharSequence)purchase.getToken())) {
                        this.logWarn("BUG: empty/null token!");
                        this.logDebug("Purchase data: " + purchaseData);
                    }
                    inv.addPurchaseToConsumablePurchaseHistory(sku, purchase);
                }
            }
            if (itemType.equals(ITEM_TYPE_SUBS)) {
                for (int i = 0; i < ownedSkus.size(); ++i) {
                    String sku = (String)ownedSkus.get(i);
                    inv.addPurchaseToSubscriptionPurchaseHistory(sku);
                }
            }
            continueToken = ownedItems.getString(INAPP_CONTINUATION_TOKEN);
            this.logDebug("Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return verificationFailed ? -1003 : 0;
    }

    int queryPurchases(Inventory inv, String itemType, IInAppBillingService service) throws JSONException, RemoteException {
        if (this.mDisposed) {
            this.logDebug("queryPurchases - Biller disposed. Returning...");
            return 0;
        }
        this.logDebug("Querying owned items, item type: " + itemType);
        this.logDebug("Package name: " + this.mContext.getPackageName());
        boolean verificationFailed = false;
        String continueToken = null;
        do {
            this.logDebug("Calling getPurchases with continuation token: " + continueToken);
            Bundle ownedItems = service.getPurchases(3, this.mContext.getPackageName(), itemType, continueToken);
            int response = this.getResponseCodeFromBundle(ownedItems);
            this.logDebug("Owned items response: " + String.valueOf(response));
            if (response != 0) {
                this.logDebug("getPurchases() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            if (!(ownedItems.containsKey(RESPONSE_INAPP_ITEM_LIST) && ownedItems.containsKey(RESPONSE_INAPP_PURCHASE_DATA_LIST) && ownedItems.containsKey(RESPONSE_INAPP_SIGNATURE_LIST))) {
                this.logError("Bundle returned from getPurchases() doesn't contain required fields.");
                return -1002;
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
            ArrayList purchaseDataList = ownedItems.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
            ArrayList signatureList = ownedItems.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                this.logDebug("Sku is owned: " + sku);
                Purchase purchase = new Purchase(itemType, purchaseData, signature);
                if (TextUtils.isEmpty((CharSequence)purchase.getToken())) {
                    this.logWarn("BUG: empty/null token!");
                    this.logDebug("Purchase data: " + purchaseData);
                }
                inv.addPurchase(purchase);
            }
            continueToken = ownedItems.getString(INAPP_CONTINUATION_TOKEN);
            this.logDebug("Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return verificationFailed ? -1003 : 0;
    }

    int querySkuDetails(String itemType, Inventory inv, List<String> moreSkus, IInAppBillingService service) throws RemoteException, JSONException {
        this.logDebug("Querying SKU details.");
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.addAll(inv.getAllOwnedSkus(itemType));
        if (moreSkus != null) {
            skuList.addAll(moreSkus);
        }
        if (skuList.size() == 0) {
            this.logDebug("queryPrices: nothing to do because there are no SKUs.");
            return 0;
        }
        while (skuList.size() > 0) {
            int endIndex = Math.min(20, skuList.size());
            ArrayList chunk = new ArrayList();
            for (int t = 0; t < endIndex; ++t) {
                chunk.add(skuList.get(t));
            }
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, chunk);
            Bundle skuDetails = service.getSkuDetails(3, this.mContext.getPackageName(), itemType, querySkus);
            skuList.removeAll(chunk);
            if (!skuDetails.containsKey(RESPONSE_GET_SKU_DETAILS_LIST)) {
                int response = this.getResponseCodeFromBundle(skuDetails);
                if (response != 0) {
                    this.logDebug("getSkuDetails() failed: " + IabHelper.getResponseDesc(response));
                    return response;
                }
                this.logError("getSkuDetails() returned a bundle with neither an error nor a detail list.");
                return -1002;
            }
            ArrayList responseList = skuDetails.getStringArrayList(RESPONSE_GET_SKU_DETAILS_LIST);
            for (String thisResponse : responseList) {
                SkuDetails d = new SkuDetails(itemType, thisResponse);
                inv.addSkuDetails(d);
            }
        }
        return 0;
    }

    void consumeAsyncInternal(final List<Purchase> purchases, final OnConsumeFinishedListener singleListener, final OnConsumeMultiFinishedListener multiListener, final boolean isSilent) {
        this.serviceManager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                ArrayList<IabResult> results = new ArrayList<IabResult>();
                for (Purchase purchase : purchases) {
                    try {
                        if (isSilent) {
                            IabHelper.this.consumeSilently(purchase, service);
                        } else {
                            IabHelper.this.consume(purchase, service);
                        }
                        results.add(new IabResult(0, "Successful consume of sku " + purchase.getSku()));
                    }
                    catch (IabException ex) {
                        results.add(ex.getResult());
                    }
                }
                if (!IabHelper.this.mDisposed && singleListener != null) {
                    try {
                        singleListener.onConsumeFinished((Purchase)purchases.get(0), (IabResult)results.get(0));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (!IabHelper.this.mDisposed && multiListener != null) {
                    multiListener.onConsumeMultiFinished(purchases, results);
                }
            }
        });
    }

    public static String byteArrayToHexString(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    void logDebug(String msg) {
        Log.i((String)"UnityIAP", (String)msg);
    }

    void logError(String msg) {
        Log.e((String)this.mDebugTag, (String)("In-app billing error: " + msg));
    }

    void logWarn(String msg) {
        Log.w((String)this.mDebugTag, (String)("In-app billing warning: " + msg));
    }

    String getAccountId(String developerPayload) {
        String accountId = null;
        try {
            JSONObject json = new JSONObject(developerPayload);
            if (json.has("accountId") && json.getString("accountId") != null && !json.getString("accountId").isEmpty()) {
                accountId = json.getString("accountId");
                this.logDebug("accountId is: " + accountId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return accountId;
    }

    static {
        billingResponseCodeNames.put(0, "BILLING_RESPONSE_RESULT_OK");
        billingResponseCodeNames.put(1, "BILLING_RESPONSE_RESULT_USER_CANCELED");
        billingResponseCodeNames.put(2, "BILLING_RESPONSE_RESULT_SERVICE_UNAVAILABLE");
        billingResponseCodeNames.put(3, "BILLING_RESPONSE_RESULT_BILLING_UNAVAILABLE");
        billingResponseCodeNames.put(4, "BILLING_RESPONSE_RESULT_ITEM_UNAVAILABLE");
        billingResponseCodeNames.put(5, "BILLING_RESPONSE_RESULT_DEVELOPER_ERROR");
        billingResponseCodeNames.put(6, "BILLING_RESPONSE_RESULT_ERROR");
        billingResponseCodeNames.put(7, "BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED");
        billingResponseCodeNames.put(8, "BILLING_RESPONSE_RESULT_ITEM_NOT_OWNED");
        billingResponseCodeNames.put(-1000, "IABHELPER_ERROR_BASE");
        billingResponseCodeNames.put(-1001, "IABHELPER_REMOTE_EXCEPTION");
        billingResponseCodeNames.put(-1002, "IABHELPER_BAD_RESPONSE");
        billingResponseCodeNames.put(-1003, "IABHELPER_VERIFICATION_FAILED");
        billingResponseCodeNames.put(-1004, "IABHELPER_SEND_INTENT_FAILED");
        billingResponseCodeNames.put(-1005, "IABHELPER_USER_CANCELLED");
        billingResponseCodeNames.put(-1006, "IABHELPER_UNKNOWN_PURCHASE_RESPONSE");
        billingResponseCodeNames.put(-1007, "IABHELPER_MISSING_TOKEN");
        billingResponseCodeNames.put(-1008, "IABHELPER_UNKNOWN_ERROR");
        billingResponseCodeNames.put(-1009, "IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE");
        billingResponseCodeNames.put(-1010, "IABHELPER_INVALID_CONSUMPTION");
    }

    public static interface OnConsumeMultiFinishedListener {
        public void onConsumeMultiFinished(List<Purchase> var1, List<IabResult> var2);
    }

    public static interface OnConsumeFinishedListener {
        public void onConsumeFinished(Purchase var1, IabResult var2) throws JSONException;
    }

    public static interface QueryInventoryFinishedListener {
        public void onQueryInventoryFinished(IabResult var1, Inventory var2) throws Exception;
    }

    public static interface OnIabPurchaseFinishedListener {
        public void onIabPurchaseFinished(IabResult var1, Purchase var2);
    }

    public static interface OnIabSetupFinishedListener {
        public void onIabSetupFinished(IabResult var1);
    }
}

