/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.iap.lib.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.samsung.android.sdk.iap.lib.helper.SamsungIapHelper;
import com.samsung.android.sdk.iap.lib.listener.OnGetInboxListener;
import com.samsung.android.sdk.iap.lib.listener.OnGetItemListener;
import com.samsung.android.sdk.iap.lib.listener.OnIapBindListener;
import com.samsung.android.sdk.iap.lib.listener.OnPaymentListener;
import com.samsung.android.sdk.iap.lib.vo.ErrorVo;
import com.samsung.android.sdk.iap.lib.vo.InboxVo;
import com.samsung.android.sdk.iap.lib.vo.ItemVo;
import com.samsung.android.sdk.iap.lib.vo.PurchaseVo;
import com.unity.purchasing.samsung.R;
import java.util.ArrayList;

public abstract class BaseActivity
extends Activity {
    private static final String TAG = BaseActivity.class.getSimpleName();
    private int mIapMode = 0;
    protected ErrorVo mErrorVo = new ErrorVo();
    protected PurchaseVo mPurchaseVo = null;
    protected ArrayList<ItemVo> mItemList = null;
    protected ArrayList<InboxVo> mInbox = null;
    private Dialog mProgressDialog = null;
    SamsungIapHelper mSamsungIapHelper = null;
    protected boolean mShowSuccessDialog = true;
    protected boolean mShowErrorDialog = true;

    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.getIntent();
        if (intent != null && intent.getExtras() != null) {
            Bundle extras = intent.getExtras();
            this.mIapMode = extras.getInt("IapMode", 0);
        }
        this.mSamsungIapHelper = SamsungIapHelper.getInstance((Context)this, this.mIapMode);
        try {
            this.mProgressDialog = new Dialog((Context)this, R.style.Theme_Empty);
            this.mProgressDialog.setContentView(R.layout.progress_dialog);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onCreate(savedInstanceState);
    }

    public void setItemList(ArrayList<ItemVo> _itemList) {
        this.mItemList = _itemList;
    }

    public void setPurchaseVo(PurchaseVo _purchaseVo) {
        this.mPurchaseVo = _purchaseVo;
    }

    public void setInbox(ArrayList<InboxVo> _inbox) {
        this.mInbox = _inbox;
    }

    public void setErrorVo(ErrorVo _errorVo) {
        this.mErrorVo = _errorVo;
    }

    public boolean checkIapPackage() {
        if (this.mSamsungIapHelper.isInstalledIapPackage((Context)this)) {
            if (this.mSamsungIapHelper.isValidIapPackage((Context)this)) {
                return true;
            }
            this.mErrorVo.setError(-1002, this.getString(R.string.IDS_SAPPS_POP_YOUR_PURCHASE_VIA_SAMSUNG_IN_APP_PURCHASE_IS_INVALID_A_FAKE_APPLICATION_HAS_BEEN_DETECTED_CHECK_THE_APP_MSG));
            this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.getString(R.string.IDS_SAPPS_POP_YOUR_PURCHASE_VIA_SAMSUNG_IN_APP_PURCHASE_IS_INVALID_A_FAKE_APPLICATION_HAS_BEEN_DETECTED_CHECK_THE_APP_MSG), true, null, this.mShowErrorDialog);
        } else {
            this.mSamsungIapHelper.installIapPackage(this);
        }
        return false;
    }

    public void bindIapService() {
        Log.i((String)TAG, (String)"start Bind... ");
        this.mSamsungIapHelper.bindIapService(new OnIapBindListener(){

            @Override
            public void onBindIapFinished(int _result) {
                Log.i((String)TAG, (String)"Binding OK... ");
                if (_result == 0) {
                    BaseActivity.this.succeedBind();
                } else {
                    BaseActivity.this.mErrorVo.setError(-1002, BaseActivity.this.getString(R.string.IDS_SAPPS_POP_YOUR_PURCHASE_VIA_SAMSUNG_IN_APP_PURCHASE_IS_INVALID_A_FAKE_APPLICATION_HAS_BEEN_DETECTED_CHECK_THE_APP_MSG));
                    BaseActivity.this.mSamsungIapHelper.showIapDialogIfNeeded(BaseActivity.this, BaseActivity.this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), BaseActivity.this.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED) + "[Lib_Bind]", true, null, BaseActivity.this.mShowErrorDialog);
                }
            }
        });
    }

    protected void onDestroy() {
        try {
            if (this.mProgressDialog != null) {
                this.mProgressDialog.dismiss();
                this.mProgressDialog = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != this.mSamsungIapHelper) {
            OnPaymentListener onPaymentListener;
            OnGetItemListener onItemListener;
            OnGetInboxListener onGetInboxListener = this.mSamsungIapHelper.getOnGetInboxListener();
            if (null != onGetInboxListener) {
                onGetInboxListener.onGetItemInbox(this.mErrorVo, this.mInbox);
            }
            if (null != (onItemListener = this.mSamsungIapHelper.getOnGetItemListener())) {
                onItemListener.onGetItem(this.mErrorVo, this.mItemList);
            }
            if (null != (onPaymentListener = this.mSamsungIapHelper.getOnPaymentListener())) {
                onPaymentListener.onPayment(this.mErrorVo, this.mPurchaseVo);
            }
            this.mSamsungIapHelper.removeAllListener();
            this.mSamsungIapHelper.dispose();
            this.mSamsungIapHelper = null;
        }
        super.onDestroy();
    }

    abstract void succeedBind();
}

