/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.iap.lib.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.samsung.android.sdk.iap.lib.activity.BaseActivity;
import com.samsung.android.sdk.iap.lib.listener.OnInitIapListener;
import com.samsung.android.sdk.iap.lib.vo.PurchaseVo;
import com.unity.purchasing.samsung.R;

public class PaymentActivity
extends BaseActivity
implements OnInitIapListener {
    private static final String TAG = PaymentActivity.class.getSimpleName();
    private String mItemId = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null && intent.getExtras() != null && intent.getExtras().containsKey("ItemId")) {
            Bundle extras = intent.getExtras();
            this.mItemId = extras.getString("ItemId");
            this.mShowSuccessDialog = extras.getBoolean("ShowSuccessDialog", true);
            this.mShowErrorDialog = extras.getBoolean("ShowErrorDialog", true);
        } else {
            Toast.makeText((Context)this, (int)R.string.IDS_SAPPS_POP_AN_INVALID_VALUE_HAS_BEEN_PROVIDED_FOR_SAMSUNG_IN_APP_PURCHASE, (int)1).show();
            this.mErrorVo.setError(-1002, this.getString(R.string.IDS_SAPPS_POP_AN_INVALID_VALUE_HAS_BEEN_PROVIDED_FOR_SAMSUNG_IN_APP_PURCHASE));
            this.finish();
        }
        this.mSamsungIapHelper.setOnInitIapListener(this);
        if (this.checkIapPackage()) {
            if (this.mErrorVo.getErrorCode() == 0) {
                this.mErrorVo.setError(1, this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
            }
            Log.i((String)TAG, (String)"Samsung Account Login...");
            this.mSamsungIapHelper.startAccountActivity(this);
        }
    }

    @Override
    protected void succeedBind() {
        if (this.mSamsungIapHelper != null) {
            this.mSamsungIapHelper.safeInitIap(this, this.mShowErrorDialog);
        }
    }

    protected void onActivityResult(int _requestCode, int _resultCode, Intent _intent) {
        switch (_requestCode) {
            case 1: {
                if (-1 == _resultCode) {
                    this.finishPurchase(_intent);
                    break;
                }
                if (0 != _resultCode) break;
                this.mErrorVo.setError(1, this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
                this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
                break;
            }
            case 2: {
                Log.i((String)TAG, (String)("Samsung Account Result : " + _resultCode));
                if (-1 == _resultCode) {
                    this.bindIapService();
                    break;
                }
                this.mErrorVo.setError(1, this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
                this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED), true, null, this.mShowErrorDialog);
            }
        }
    }

    @Override
    public void onSucceedInitIap() {
        this.mErrorVo.setError(1, this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
        this.mSamsungIapHelper.startPaymentActivity(this, 1, this.mItemId);
    }

    private void finishPurchase(Intent _intent) {
        if (null != _intent && null != _intent.getExtras()) {
            Bundle extras = _intent.getExtras();
            this.mErrorVo.setError(extras.getInt("STATUS_CODE"), extras.getString("ERROR_STRING"));
            if (this.mErrorVo.getErrorCode() == 0) {
                this.mPurchaseVo = new PurchaseVo(extras.getString("RESULT_OBJECT"));
                this.mSamsungIapHelper.verifyPurchaseResult(this, this.mPurchaseVo, this.mShowSuccessDialog, this.mShowErrorDialog);
            } else {
                this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
            }
        } else {
            this.mErrorVo.setError(-1002, this.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
            this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED) + "[Lib_Payment]", true, null, this.mShowErrorDialog);
            return;
        }
    }
}

