/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.samsung;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.samsung.android.sdk.iap.lib.helper.SamsungIapHelper;
import com.samsung.android.sdk.iap.lib.listener.OnGetInboxListener;
import com.samsung.android.sdk.iap.lib.listener.OnGetItemListener;
import com.samsung.android.sdk.iap.lib.listener.OnIapBindListener;
import com.samsung.android.sdk.iap.lib.listener.OnPaymentListener;
import com.samsung.android.sdk.iap.lib.vo.ErrorVo;
import com.samsung.android.sdk.iap.lib.vo.InboxVo;
import com.samsung.android.sdk.iap.lib.vo.ItemVo;
import com.samsung.android.sdk.iap.lib.vo.PurchaseVo;
import com.unity.purchasing.common.IStoreCallback;
import com.unity.purchasing.common.IUnityCallback;
import com.unity.purchasing.common.InitializationFailureReason;
import com.unity.purchasing.common.ProductDefinition;
import com.unity.purchasing.common.ProductDescription;
import com.unity.purchasing.common.ProductMetadata;
import com.unity.purchasing.common.PurchaseFailureDescription;
import com.unity.purchasing.common.PurchaseFailureReason;
import com.unity.purchasing.common.StoreDeserializer;
import com.unity.purchasing.common.UnityPurchasing;
import com.unity.purchasing.samsung.ISamsungAppsStoreCallback;
import com.unity.purchasing.samsung.SamsungAppsMode;
import com.unity3d.player.UnityPlayer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class SamsungPurchasing
extends StoreDeserializer
implements OnGetItemListener,
OnPaymentListener,
OnGetInboxListener,
OnIapBindListener {
    private static final String UNIBILL_GAMEOBJECT_NAME = "SamsungAppsCallbackMonoBehaviour";
    private static final String UNITY_METHOD_NAME_TRANSACTIONS_RESTORED = "OnTransactionsRestored";
    public static final String TAG = "UnityIAP SamsungApps";
    private static volatile SamsungPurchasing instance;
    private volatile SamsungIapHelper helper;
    private volatile ExecutorService executor = Executors.newSingleThreadExecutor();
    private IStoreCallback unityPurchasing;
    private ISamsungAppsStoreCallback samsungExtension;
    private int mode = 0;
    private String productIdUnderPurchase;

    public static SamsungPurchasing instance(IUnityCallback bridge, ISamsungAppsStoreCallback samsungExtension) {
        if (instance == null) {
            instance = new SamsungPurchasing((IStoreCallback)new UnityPurchasing(bridge), samsungExtension);
        }
        return instance;
    }

    public SamsungPurchasing(IStoreCallback callback, ISamsungAppsStoreCallback samsungExtension) {
        this.unityPurchasing = callback;
        this.samsungExtension = samsungExtension;
    }

    public void initialize() {
        this.log("initialise");
        this.log("Checking for samsung IAP service...");
        if (!this.isSamsungIAPServiceInstalled()) {
            this.log("Installing Samsung IAP service");
            try {
                this.installSamsungIAPService();
                this.log("Samsung Apps needs to install, then restart your App.");
                this.unityPurchasing.OnSetupFailed(InitializationFailureReason.PurchasingUnavailable);
                return;
            }
            catch (Exception e) {
                this.log("Samsung Apps cannot be installed");
                this.unityPurchasing.OnSetupFailed(InitializationFailureReason.PurchasingUnavailable);
                return;
            }
        }
        this.log("Samsung IAP service installed");
        this.helper = this.createHelper();
        this.helper.bindIapService(this);
    }

    private SamsungIapHelper createHelper() {
        this.helper = SamsungIapHelper.getInstance((Context)UnityPlayer.currentActivity, this.mode);
        return this.helper;
    }

    public void setMode(String modeString) {
        if (modeString != null) {
            SamsungAppsMode mode = SamsungAppsMode.valueOf(modeString);
            int modeCode = 0;
            switch (mode) {
                case AlwaysFail: {
                    modeCode = -1;
                    break;
                }
                case AlwaysSucceed: {
                    modeCode = 1;
                }
            }
            this.mode = modeCode;
        }
        if (this.helper != null) {
            this.helper = SamsungIapHelper.getInstance((Context)UnityPlayer.currentActivity, this.mode);
        }
    }

    private void installSamsungIAPService() {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)"samsungapps://ProductDetail/com.sec.android.app.billing"));
        if (Build.VERSION.SDK_INT >= 12) {
            intent.addFlags(335544352);
        } else {
            intent.addFlags(0x14000000);
        }
        UnityPlayer.currentActivity.startActivity(intent);
        UnityPlayer.currentActivity.finish();
    }

    private boolean isSamsungIAPServiceInstalled() {
        PackageManager pm = UnityPlayer.currentActivity.getPackageManager();
        try {
            pm.getApplicationInfo("com.sec.android.app.billing", 128);
            PackageInfo packageInfo = pm.getPackageInfo("com.sec.android.app.billing", 128);
            if (packageInfo.versionCode < 400000000) {
                this.log("existing Samsung IAP service version is too low");
                return false;
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private void getItemList(final long delayInMilliseconds) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delayInMilliseconds);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SamsungPurchasing.this.log("Fetching item list...");
                SamsungPurchasing.this.helper.getItemList(1, Integer.MAX_VALUE, "10", SamsungPurchasing.this.mode, SamsungPurchasing.this);
            }
        });
    }

    private void log(String message) {
        Log.i((String)TAG, (String)message);
    }

    private void log(String message, String arg) {
        this.log(String.format(message, arg));
    }

    @Override
    public void onGetItem(ErrorVo error, ArrayList<ItemVo> itemList) {
        this.log("onGetItem response:" + error.getErrorCode());
        if (error.getErrorCode() == 0) {
            ArrayList<ProductDescription> products = new ArrayList<ProductDescription>();
            for (ItemVo item : itemList) {
                ProductMetadata metadata = new ProductMetadata(item.getItemPriceString(), item.getItemName(), item.getItemDesc(), Currency.getInstance(Locale.getDefault()).getCurrencyCode(), BigDecimal.valueOf(item.getItemPrice()));
                String receipt = "";
                String transactionId = "";
                products.add(new ProductDescription(item.getItemId(), metadata, receipt, transactionId));
            }
            this.unityPurchasing.OnProductsRetrieved(products);
        } else {
            this.log("Error message: " + error.getErrorString());
            this.log("Failure retrieving item list. SamsungPurchasing will retry in 10 seconds...");
            this.getItemList(10000L);
        }
    }

    @Override
    public void onPayment(ErrorVo error, PurchaseVo purchase) {
        this.log("Purchase result:" + error.getErrorCode());
        switch (error.getErrorCode()) {
            case -1003: 
            case 0: {
                if (null == purchase) {
                    this.notifyPurchase(this.productIdUnderPurchase, "", "");
                    break;
                }
                this.notifyPurchase(purchase.getItemId(), purchase.getPurchaseId(), purchase.getPaymentId());
                break;
            }
            case 1: {
                this.unityPurchasing.OnPurchaseFailed(new PurchaseFailureDescription(this.productIdUnderPurchase, PurchaseFailureReason.UserCancelled, "error: " + error.getErrorString() + ", " + "message: " + error.getExtraString(), null));
                break;
            }
            default: {
                this.unityPurchasing.OnPurchaseFailed(new PurchaseFailureDescription(this.productIdUnderPurchase, PurchaseFailureReason.Unknown, "error: " + error.getErrorString() + ", " + "message: " + error.getExtraString(), null));
            }
        }
    }

    @Override
    public void onGetItemInbox(ErrorVo error, ArrayList<InboxVo> inbox) {
        this.log("onGetItem response:" + error.getErrorCode());
        if (error.getErrorCode() == 0) {
            for (InboxVo item : inbox) {
                if (item.getType().equals("00")) continue;
                this.notifyPurchase(item.getItemId(), item.getJsonString(), "");
            }
            this.samsungExtension.OnTransactionsRestored(true);
        } else {
            this.log("Failure retrieving item list");
            this.samsungExtension.OnTransactionsRestored(false);
        }
    }

    private void notifyPurchase(String productId, String purchaseId, String paymentId) {
        this.unityPurchasing.OnPurchaseSucceeded(productId, this.encodeReceipt(purchaseId), paymentId);
    }

    private String encodeReceipt(String purchaseId) {
        JSONObject signature = new JSONObject();
        try {
            signature.put("purchaseId", (Object)purchaseId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return signature.toString();
    }

    @Override
    public void onBindIapFinished(int result) {
        this.log("onBindIapFinished:%s", String.valueOf(result));
        if (result == 0) {
            this.log("Initialised successfully!");
            this.getItemList(0L);
        } else {
            this.log("onBindIapFinished InitializationFailureReason.PurchasingUnavailable");
            this.unityPurchasing.OnSetupFailed(InitializationFailureReason.PurchasingUnavailable);
        }
    }

    public void RetrieveProducts(List<ProductDefinition> products) {
        if (this.helper == null) {
            this.initialize();
        } else {
            this.getItemList(0L);
        }
    }

    public void Purchase(ProductDefinition product) {
        this.Purchase(product, null);
    }

    public void Purchase(ProductDefinition product, String developerPayload) {
        this.productIdUnderPurchase = product.storeSpecificId;
        this.helper.startPayment(this.productIdUnderPurchase, false, this);
    }

    public void FinishTransaction(ProductDefinition product, String transactionID) {
        this.log("FinishTransaction");
    }

    public void restoreTransactions() {
        this.log("Restoring transactions...");
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        String today = sdf.format(d);
        this.helper.getItemInboxList(1, Integer.MAX_VALUE, "20130101", today, this);
    }
}

